/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferApplianceAsync;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceAdminCredentialsConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceCertificateAuthorityCertificateConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceEncryptionPassphraseConverter;
import com.oracle.bmc.dts.internal.http.ListTransferAppliancesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferApplianceConverter;
import com.oracle.bmc.dts.requests.CreateTransferApplianceAdminCredentialsRequest;
import com.oracle.bmc.dts.requests.CreateTransferApplianceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferApplianceRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceCertificateAuthorityCertificateRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEncryptionPassphraseRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceRequest;
import com.oracle.bmc.dts.requests.ListTransferAppliancesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferApplianceRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceAdminCredentialsResponse;
import com.oracle.bmc.dts.responses.CreateTransferApplianceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferApplianceResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceCertificateAuthorityCertificateResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEncryptionPassphraseResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceResponse;
import com.oracle.bmc.dts.responses.ListTransferAppliancesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferApplianceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceAsyncClient
implements TransferApplianceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateTransferApplianceResponse> createTransferAppliance(CreateTransferApplianceRequest request, AsyncHandler<CreateTransferApplianceRequest, CreateTransferApplianceResponse> handler) {
        LOG.trace("Called async createTransferAppliance");
        final CreateTransferApplianceRequest interceptedRequest = CreateTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferApplianceResponse> transformer = CreateTransferApplianceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceRequest, CreateTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateTransferApplianceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getCreateTransferApplianceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateTransferApplianceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<CreateTransferApplianceAdminCredentialsResponse> createTransferApplianceAdminCredentials(CreateTransferApplianceAdminCredentialsRequest request, AsyncHandler<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse> handler) {
        LOG.trace("Called async createTransferApplianceAdminCredentials");
        final CreateTransferApplianceAdminCredentialsRequest interceptedRequest = CreateTransferApplianceAdminCredentialsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferApplianceAdminCredentialsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferApplianceAdminCredentialsResponse> transformer = CreateTransferApplianceAdminCredentialsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAdminPublicKey(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getAdminPublicKey(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAdminPublicKey(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTransferApplianceResponse> deleteTransferAppliance(DeleteTransferApplianceRequest request, AsyncHandler<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse> handler) {
        LOG.trace("Called async deleteTransferAppliance");
        final DeleteTransferApplianceRequest interceptedRequest = DeleteTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTransferApplianceResponse> transformer = DeleteTransferApplianceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferApplianceResponse> getTransferAppliance(GetTransferApplianceRequest request, AsyncHandler<GetTransferApplianceRequest, GetTransferApplianceResponse> handler) {
        LOG.trace("Called async getTransferAppliance");
        final GetTransferApplianceRequest interceptedRequest = GetTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferApplianceResponse> transformer = GetTransferApplianceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceRequest, GetTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferApplianceCertificateAuthorityCertificateResponse> getTransferApplianceCertificateAuthorityCertificate(GetTransferApplianceCertificateAuthorityCertificateRequest request, AsyncHandler<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse> handler) {
        LOG.trace("Called async getTransferApplianceCertificateAuthorityCertificate");
        final GetTransferApplianceCertificateAuthorityCertificateRequest interceptedRequest = GetTransferApplianceCertificateAuthorityCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferApplianceCertificateAuthorityCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferApplianceCertificateAuthorityCertificateResponse> transformer = GetTransferApplianceCertificateAuthorityCertificateConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferApplianceEncryptionPassphraseResponse> getTransferApplianceEncryptionPassphrase(GetTransferApplianceEncryptionPassphraseRequest request, AsyncHandler<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse> handler) {
        LOG.trace("Called async getTransferApplianceEncryptionPassphrase");
        final GetTransferApplianceEncryptionPassphraseRequest interceptedRequest = GetTransferApplianceEncryptionPassphraseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferApplianceEncryptionPassphraseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferApplianceEncryptionPassphraseResponse> transformer = GetTransferApplianceEncryptionPassphraseConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListTransferAppliancesResponse> listTransferAppliances(ListTransferAppliancesRequest request, AsyncHandler<ListTransferAppliancesRequest, ListTransferAppliancesResponse> handler) {
        LOG.trace("Called async listTransferAppliances");
        final ListTransferAppliancesRequest interceptedRequest = ListTransferAppliancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTransferAppliancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTransferAppliancesResponse> transformer = ListTransferAppliancesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTransferAppliancesRequest, ListTransferAppliancesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTransferApplianceResponse> updateTransferAppliance(UpdateTransferApplianceRequest request, AsyncHandler<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse> handler) {
        LOG.trace("Called async updateTransferAppliance");
        final UpdateTransferApplianceRequest interceptedRequest = UpdateTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTransferApplianceResponse> transformer = UpdateTransferApplianceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferApplianceAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateTransferApplianceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.put(ib, (Object)interceptedRequest.getUpdateTransferApplianceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateTransferApplianceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TransferApplianceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferApplianceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

