/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferJobAsync;
import com.oracle.bmc.dts.internal.http.ChangeTransferJobCompartmentConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferJobConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferJobConverter;
import com.oracle.bmc.dts.internal.http.GetTransferJobConverter;
import com.oracle.bmc.dts.internal.http.ListTransferJobsConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferJobConverter;
import com.oracle.bmc.dts.requests.ChangeTransferJobCompartmentRequest;
import com.oracle.bmc.dts.requests.CreateTransferJobRequest;
import com.oracle.bmc.dts.requests.DeleteTransferJobRequest;
import com.oracle.bmc.dts.requests.GetTransferJobRequest;
import com.oracle.bmc.dts.requests.ListTransferJobsRequest;
import com.oracle.bmc.dts.requests.UpdateTransferJobRequest;
import com.oracle.bmc.dts.responses.ChangeTransferJobCompartmentResponse;
import com.oracle.bmc.dts.responses.CreateTransferJobResponse;
import com.oracle.bmc.dts.responses.DeleteTransferJobResponse;
import com.oracle.bmc.dts.responses.GetTransferJobResponse;
import com.oracle.bmc.dts.responses.ListTransferJobsResponse;
import com.oracle.bmc.dts.responses.UpdateTransferJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferJobAsyncClient
implements TransferJobAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferJobAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeTransferJobCompartmentResponse> changeTransferJobCompartment(ChangeTransferJobCompartmentRequest request, AsyncHandler<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse> handler) {
        LOG.trace("Called async changeTransferJobCompartment");
        final ChangeTransferJobCompartmentRequest interceptedRequest = ChangeTransferJobCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeTransferJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeTransferJobCompartmentResponse> transformer = ChangeTransferJobCompartmentConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferJobAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeTransferJobCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getChangeTransferJobCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeTransferJobCompartmentDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<CreateTransferJobResponse> createTransferJob(CreateTransferJobRequest request, AsyncHandler<CreateTransferJobRequest, CreateTransferJobResponse> handler) {
        LOG.trace("Called async createTransferJob");
        final CreateTransferJobRequest interceptedRequest = CreateTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferJobResponse> transformer = CreateTransferJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferJobRequest, CreateTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferJobAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateTransferJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getCreateTransferJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateTransferJobDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTransferJobResponse> deleteTransferJob(DeleteTransferJobRequest request, AsyncHandler<DeleteTransferJobRequest, DeleteTransferJobResponse> handler) {
        LOG.trace("Called async deleteTransferJob");
        final DeleteTransferJobRequest interceptedRequest = DeleteTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTransferJobResponse> transformer = DeleteTransferJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTransferJobRequest, DeleteTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferJobAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferJobResponse> getTransferJob(GetTransferJobRequest request, AsyncHandler<GetTransferJobRequest, GetTransferJobResponse> handler) {
        LOG.trace("Called async getTransferJob");
        final GetTransferJobRequest interceptedRequest = GetTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferJobResponse> transformer = GetTransferJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferJobRequest, GetTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferJobAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListTransferJobsResponse> listTransferJobs(ListTransferJobsRequest request, AsyncHandler<ListTransferJobsRequest, ListTransferJobsResponse> handler) {
        LOG.trace("Called async listTransferJobs");
        final ListTransferJobsRequest interceptedRequest = ListTransferJobsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTransferJobsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTransferJobsResponse> transformer = ListTransferJobsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTransferJobsRequest, ListTransferJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferJobAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTransferJobResponse> updateTransferJob(UpdateTransferJobRequest request, AsyncHandler<UpdateTransferJobRequest, UpdateTransferJobResponse> handler) {
        LOG.trace("Called async updateTransferJob");
        final UpdateTransferJobRequest interceptedRequest = UpdateTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTransferJobResponse> transformer = UpdateTransferJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTransferJobRequest, UpdateTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    TransferJobAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateTransferJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.put(ib, (Object)interceptedRequest.getUpdateTransferJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateTransferJobDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferJobAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TransferJobAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferJobAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

