/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferPackage;
import com.oracle.bmc.dts.TransferPackageWaiters;
import com.oracle.bmc.dts.internal.http.AttachDevicesToTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.DetachDevicesFromTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.GetTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.ListTransferPackagesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferPackageConverter;
import com.oracle.bmc.dts.requests.AttachDevicesToTransferPackageRequest;
import com.oracle.bmc.dts.requests.CreateTransferPackageRequest;
import com.oracle.bmc.dts.requests.DeleteTransferPackageRequest;
import com.oracle.bmc.dts.requests.DetachDevicesFromTransferPackageRequest;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.requests.ListTransferPackagesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferPackageRequest;
import com.oracle.bmc.dts.responses.AttachDevicesToTransferPackageResponse;
import com.oracle.bmc.dts.responses.CreateTransferPackageResponse;
import com.oracle.bmc.dts.responses.DeleteTransferPackageResponse;
import com.oracle.bmc.dts.responses.DetachDevicesFromTransferPackageResponse;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.dts.responses.ListTransferPackagesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferPackageResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferPackageClient
implements TransferPackage {
    private static final Logger LOG = LoggerFactory.getLogger(TransferPackageClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERPACKAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final TransferPackageWaiters waiters;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public TransferPackageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferPackageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferPackageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TransferPackage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new TransferPackageWaiters(executorService, this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AttachDevicesToTransferPackageResponse attachDevicesToTransferPackage(AttachDevicesToTransferPackageRequest request) {
        LOG.trace("Called attachDevicesToTransferPackage");
        AttachDevicesToTransferPackageRequest interceptedRequest = AttachDevicesToTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachDevicesToTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachDevicesToTransferPackageResponse> transformer = AttachDevicesToTransferPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (AttachDevicesToTransferPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachDevicesToTransferPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachDevicesDetails(), (BmcRequest)retriedRequest);
                return (AttachDevicesToTransferPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTransferPackageResponse createTransferPackage(CreateTransferPackageRequest request) {
        LOG.trace("Called createTransferPackage");
        CreateTransferPackageRequest interceptedRequest = CreateTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTransferPackageResponse> transformer = CreateTransferPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateTransferPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTransferPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTransferPackageDetails(), (BmcRequest)retriedRequest);
                return (CreateTransferPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTransferPackageResponse deleteTransferPackage(DeleteTransferPackageRequest request) {
        LOG.trace("Called deleteTransferPackage");
        DeleteTransferPackageRequest interceptedRequest = DeleteTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTransferPackageResponse> transformer = DeleteTransferPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTransferPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTransferPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTransferPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetachDevicesFromTransferPackageResponse detachDevicesFromTransferPackage(DetachDevicesFromTransferPackageRequest request) {
        LOG.trace("Called detachDevicesFromTransferPackage");
        DetachDevicesFromTransferPackageRequest interceptedRequest = DetachDevicesFromTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachDevicesFromTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachDevicesFromTransferPackageResponse> transformer = DetachDevicesFromTransferPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DetachDevicesFromTransferPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachDevicesFromTransferPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachDevicesDetails(), (BmcRequest)retriedRequest);
                return (DetachDevicesFromTransferPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTransferPackageResponse getTransferPackage(GetTransferPackageRequest request) {
        LOG.trace("Called getTransferPackage");
        GetTransferPackageRequest interceptedRequest = GetTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferPackageResponse> transformer = GetTransferPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTransferPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTransferPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTransferPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTransferPackagesResponse listTransferPackages(ListTransferPackagesRequest request) {
        LOG.trace("Called listTransferPackages");
        ListTransferPackagesRequest interceptedRequest = ListTransferPackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTransferPackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTransferPackagesResponse> transformer = ListTransferPackagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTransferPackagesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTransferPackagesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTransferPackagesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTransferPackageResponse updateTransferPackage(UpdateTransferPackageRequest request) {
        LOG.trace("Called updateTransferPackage");
        UpdateTransferPackageRequest interceptedRequest = UpdateTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTransferPackageResponse> transformer = UpdateTransferPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTransferPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTransferPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTransferPackageDetails(), (BmcRequest)retriedRequest);
                return (UpdateTransferPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TransferPackageWaiters getWaiters() {
        return this.waiters;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferPackageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public TransferPackageClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferPackageClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

