/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dts.model.TransferApplianceEntitlementSummary;
import com.oracle.bmc.dts.requests.ListTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.responses.ListTransferApplianceEntitlementResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTransferApplianceEntitlementConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTransferApplianceEntitlementConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTransferApplianceEntitlementRequest interceptRequest(ListTransferApplianceEntitlementRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTransferApplianceEntitlementRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20171001").path("transferApplianceEntitlement");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getId() != null) {
            target = target.queryParam("id", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getId())});
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListTransferApplianceEntitlementResponse> fromResponse() {
        Function<Response, ListTransferApplianceEntitlementResponse> transformer = new Function<Response, ListTransferApplianceEntitlementResponse>(){

            public ListTransferApplianceEntitlementResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ListTransferApplianceEntitlementResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<TransferApplianceEntitlementSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListTransferApplianceEntitlementResponse.Builder builder = ListTransferApplianceEntitlementResponse.builder();
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListTransferApplianceEntitlementResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

