/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dts.model.TransferPackage;
import com.oracle.bmc.dts.requests.UpdateTransferPackageRequest;
import com.oracle.bmc.dts.responses.UpdateTransferPackageResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTransferPackageConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTransferPackageConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateTransferPackageRequest interceptRequest(UpdateTransferPackageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateTransferPackageRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateTransferPackageDetails(), (String)"updateTransferPackageDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20171001").path("transferJobs").path(HttpUtils.encodePathSegment((String)request.getId())).path("transferPackages").path(HttpUtils.encodePathSegment((String)request.getTransferPackageLabel()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateTransferPackageResponse> fromResponse() {
        Function<Response, UpdateTransferPackageResponse> transformer = new Function<Response, UpdateTransferPackageResponse>(){

            public UpdateTransferPackageResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for UpdateTransferPackageResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TransferPackage.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateTransferPackageResponse.Builder builder = UpdateTransferPackageResponse.builder();
                builder.transferPackage((TransferPackage)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                UpdateTransferPackageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

