/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.TransferAppliancePublicKey;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateTransferApplianceAdminCredentialsRequest
extends BmcRequest {
    private String id;
    private String transferApplianceLabel;
    private TransferAppliancePublicKey adminPublicKey;

    @ConstructorProperties(value={"id", "transferApplianceLabel", "adminPublicKey"})
    CreateTransferApplianceAdminCredentialsRequest(String id, String transferApplianceLabel, TransferAppliancePublicKey adminPublicKey) {
        this.id = id;
        this.transferApplianceLabel = transferApplianceLabel;
        this.adminPublicKey = adminPublicKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTransferApplianceLabel() {
        return this.transferApplianceLabel;
    }

    public TransferAppliancePublicKey getAdminPublicKey() {
        return this.adminPublicKey;
    }

    public static class Builder {
        private String id;
        private String transferApplianceLabel;
        private TransferAppliancePublicKey adminPublicKey;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferApplianceAdminCredentialsRequest o) {
            this.id(o.getId());
            this.transferApplianceLabel(o.getTransferApplianceLabel());
            this.adminPublicKey(o.getAdminPublicKey());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferApplianceAdminCredentialsRequest build() {
            CreateTransferApplianceAdminCredentialsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferApplianceLabel(String transferApplianceLabel) {
            this.transferApplianceLabel = transferApplianceLabel;
            return this;
        }

        public Builder adminPublicKey(TransferAppliancePublicKey adminPublicKey) {
            this.adminPublicKey = adminPublicKey;
            return this;
        }

        public CreateTransferApplianceAdminCredentialsRequest buildWithoutInvocationCallback() {
            return new CreateTransferApplianceAdminCredentialsRequest(this.id, this.transferApplianceLabel, this.adminPublicKey);
        }

        public String toString() {
            return "CreateTransferApplianceAdminCredentialsRequest.Builder(id=" + this.id + ", transferApplianceLabel=" + this.transferApplianceLabel + ", adminPublicKey=" + this.adminPublicKey + ")";
        }
    }
}

