/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.CreateTransferPackageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateTransferPackageRequest
extends BmcRequest {
    private String id;
    private String opcRetryToken;
    private CreateTransferPackageDetails createTransferPackageDetails;

    @ConstructorProperties(value={"id", "opcRetryToken", "createTransferPackageDetails"})
    CreateTransferPackageRequest(String id, String opcRetryToken, CreateTransferPackageDetails createTransferPackageDetails) {
        this.id = id;
        this.opcRetryToken = opcRetryToken;
        this.createTransferPackageDetails = createTransferPackageDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public CreateTransferPackageDetails getCreateTransferPackageDetails() {
        return this.createTransferPackageDetails;
    }

    public static class Builder {
        private String id;
        private String opcRetryToken;
        private CreateTransferPackageDetails createTransferPackageDetails;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferPackageRequest o) {
            this.id(o.getId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.createTransferPackageDetails(o.getCreateTransferPackageDetails());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferPackageRequest build() {
            CreateTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder createTransferPackageDetails(CreateTransferPackageDetails createTransferPackageDetails) {
            this.createTransferPackageDetails = createTransferPackageDetails;
            return this;
        }

        public CreateTransferPackageRequest buildWithoutInvocationCallback() {
            return new CreateTransferPackageRequest(this.id, this.opcRetryToken, this.createTransferPackageDetails);
        }

        public String toString() {
            return "CreateTransferPackageRequest.Builder(id=" + this.id + ", opcRetryToken=" + this.opcRetryToken + ", createTransferPackageDetails=" + this.createTransferPackageDetails + ")";
        }
    }
}

