/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTransferPackageRequest
extends BmcRequest {
    private String id;
    private String transferPackageLabel;

    @ConstructorProperties(value={"id", "transferPackageLabel"})
    GetTransferPackageRequest(String id, String transferPackageLabel) {
        this.id = id;
        this.transferPackageLabel = transferPackageLabel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTransferPackageLabel() {
        return this.transferPackageLabel;
    }

    public static class Builder {
        private String id;
        private String transferPackageLabel;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTransferPackageRequest o) {
            this.id(o.getId());
            this.transferPackageLabel(o.getTransferPackageLabel());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTransferPackageRequest build() {
            GetTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferPackageLabel(String transferPackageLabel) {
            this.transferPackageLabel = transferPackageLabel;
            return this;
        }

        public GetTransferPackageRequest buildWithoutInvocationCallback() {
            return new GetTransferPackageRequest(this.id, this.transferPackageLabel);
        }

        public String toString() {
            return "GetTransferPackageRequest.Builder(id=" + this.id + ", transferPackageLabel=" + this.transferPackageLabel + ")";
        }
    }
}

