/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.UpdateTransferDeviceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateTransferDeviceRequest
extends BmcRequest {
    private String id;
    private String transferDeviceLabel;
    private UpdateTransferDeviceDetails updateTransferDeviceDetails;
    private String ifMatch;

    @ConstructorProperties(value={"id", "transferDeviceLabel", "updateTransferDeviceDetails", "ifMatch"})
    UpdateTransferDeviceRequest(String id, String transferDeviceLabel, UpdateTransferDeviceDetails updateTransferDeviceDetails, String ifMatch) {
        this.id = id;
        this.transferDeviceLabel = transferDeviceLabel;
        this.updateTransferDeviceDetails = updateTransferDeviceDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTransferDeviceLabel() {
        return this.transferDeviceLabel;
    }

    public UpdateTransferDeviceDetails getUpdateTransferDeviceDetails() {
        return this.updateTransferDeviceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String id;
        private String transferDeviceLabel;
        private UpdateTransferDeviceDetails updateTransferDeviceDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTransferDeviceRequest o) {
            this.id(o.getId());
            this.transferDeviceLabel(o.getTransferDeviceLabel());
            this.updateTransferDeviceDetails(o.getUpdateTransferDeviceDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTransferDeviceRequest build() {
            UpdateTransferDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferDeviceLabel(String transferDeviceLabel) {
            this.transferDeviceLabel = transferDeviceLabel;
            return this;
        }

        public Builder updateTransferDeviceDetails(UpdateTransferDeviceDetails updateTransferDeviceDetails) {
            this.updateTransferDeviceDetails = updateTransferDeviceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateTransferDeviceRequest buildWithoutInvocationCallback() {
            return new UpdateTransferDeviceRequest(this.id, this.transferDeviceLabel, this.updateTransferDeviceDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateTransferDeviceRequest.Builder(id=" + this.id + ", transferDeviceLabel=" + this.transferDeviceLabel + ", updateTransferDeviceDetails=" + this.updateTransferDeviceDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

