/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.TransferJob;
import java.beans.ConstructorProperties;

public class CreateTransferJobResponse {
    private String opcRequestId;
    private String etag;
    private TransferJob transferJob;

    @ConstructorProperties(value={"opcRequestId", "etag", "transferJob"})
    CreateTransferJobResponse(String opcRequestId, String etag, TransferJob transferJob) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.transferJob = transferJob;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public TransferJob getTransferJob() {
        return this.transferJob;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private TransferJob transferJob;

        public Builder copy(CreateTransferJobResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.transferJob(o.getTransferJob());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder transferJob(TransferJob transferJob) {
            this.transferJob = transferJob;
            return this;
        }

        public CreateTransferJobResponse build() {
            return new CreateTransferJobResponse(this.opcRequestId, this.etag, this.transferJob);
        }

        public String toString() {
            return "CreateTransferJobResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", transferJob=" + this.transferJob + ")";
        }
    }
}

