/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.TransferAppliance;
import java.beans.ConstructorProperties;

public class UpdateTransferApplianceResponse {
    private String opcRequestId;
    private String etag;
    private TransferAppliance transferAppliance;

    @ConstructorProperties(value={"opcRequestId", "etag", "transferAppliance"})
    UpdateTransferApplianceResponse(String opcRequestId, String etag, TransferAppliance transferAppliance) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.transferAppliance = transferAppliance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public TransferAppliance getTransferAppliance() {
        return this.transferAppliance;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private TransferAppliance transferAppliance;

        public Builder copy(UpdateTransferApplianceResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.transferAppliance(o.getTransferAppliance());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder transferAppliance(TransferAppliance transferAppliance) {
            this.transferAppliance = transferAppliance;
            return this;
        }

        public UpdateTransferApplianceResponse build() {
            return new UpdateTransferApplianceResponse(this.opcRequestId, this.etag, this.transferAppliance);
        }

        public String toString() {
            return "UpdateTransferApplianceResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", transferAppliance=" + this.transferAppliance + ")";
        }
    }
}

