/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.TransferDevice;
import java.beans.ConstructorProperties;

public class UpdateTransferDeviceResponse {
    private String opcRequestId;
    private String etag;
    private TransferDevice transferDevice;

    @ConstructorProperties(value={"opcRequestId", "etag", "transferDevice"})
    UpdateTransferDeviceResponse(String opcRequestId, String etag, TransferDevice transferDevice) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.transferDevice = transferDevice;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public TransferDevice getTransferDevice() {
        return this.transferDevice;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private TransferDevice transferDevice;

        public Builder copy(UpdateTransferDeviceResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.transferDevice(o.getTransferDevice());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder transferDevice(TransferDevice transferDevice) {
            this.transferDevice = transferDevice;
            return this;
        }

        public UpdateTransferDeviceResponse build() {
            return new UpdateTransferDeviceResponse(this.opcRequestId, this.etag, this.transferDevice);
        }

        public String toString() {
            return "UpdateTransferDeviceResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", transferDevice=" + this.transferDevice + ")";
        }
    }
}

