/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TransferDeviceSummary {
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="iscsiIQN")
    private final String iscsiIQN;
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="attachedTransferPackageLabel")
    private final String attachedTransferPackageLabel;
    @JsonProperty(value="creationTime")
    private final Date creationTime;
    @JsonProperty(value="uploadStatusLogUri")
    private final String uploadStatusLogUri;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().serialNumber(this.serialNumber).iscsiIQN(this.iscsiIQN).label(this.label).lifecycleState(this.lifecycleState).attachedTransferPackageLabel(this.attachedTransferPackageLabel).creationTime(this.creationTime).uploadStatusLogUri(this.uploadStatusLogUri);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getIscsiIQN() {
        return this.iscsiIQN;
    }

    public String getLabel() {
        return this.label;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAttachedTransferPackageLabel() {
        return this.attachedTransferPackageLabel;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getUploadStatusLogUri() {
        return this.uploadStatusLogUri;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferDeviceSummary)) {
            return false;
        }
        TransferDeviceSummary other = (TransferDeviceSummary)o;
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$iscsiIQN = this.getIscsiIQN();
        String other$iscsiIQN = other.getIscsiIQN();
        if (this$iscsiIQN == null ? other$iscsiIQN != null : !this$iscsiIQN.equals(other$iscsiIQN)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$attachedTransferPackageLabel = this.getAttachedTransferPackageLabel();
        String other$attachedTransferPackageLabel = other.getAttachedTransferPackageLabel();
        if (this$attachedTransferPackageLabel == null ? other$attachedTransferPackageLabel != null : !this$attachedTransferPackageLabel.equals(other$attachedTransferPackageLabel)) {
            return false;
        }
        Date this$creationTime = this.getCreationTime();
        Date other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        String this$uploadStatusLogUri = this.getUploadStatusLogUri();
        String other$uploadStatusLogUri = other.getUploadStatusLogUri();
        if (this$uploadStatusLogUri == null ? other$uploadStatusLogUri != null : !this$uploadStatusLogUri.equals(other$uploadStatusLogUri)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $iscsiIQN = this.getIscsiIQN();
        result = result * 59 + ($iscsiIQN == null ? 43 : $iscsiIQN.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $attachedTransferPackageLabel = this.getAttachedTransferPackageLabel();
        result = result * 59 + ($attachedTransferPackageLabel == null ? 43 : $attachedTransferPackageLabel.hashCode());
        Date $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        String $uploadStatusLogUri = this.getUploadStatusLogUri();
        result = result * 59 + ($uploadStatusLogUri == null ? 43 : $uploadStatusLogUri.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "TransferDeviceSummary(serialNumber=" + this.getSerialNumber() + ", iscsiIQN=" + this.getIscsiIQN() + ", label=" + this.getLabel() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", attachedTransferPackageLabel=" + this.getAttachedTransferPackageLabel() + ", creationTime=" + this.getCreationTime() + ", uploadStatusLogUri=" + this.getUploadStatusLogUri() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"serialNumber", "iscsiIQN", "label", "lifecycleState", "attachedTransferPackageLabel", "creationTime", "uploadStatusLogUri"})
    @Deprecated
    public TransferDeviceSummary(String serialNumber, String iscsiIQN, String label, LifecycleState lifecycleState, String attachedTransferPackageLabel, Date creationTime, String uploadStatusLogUri) {
        this.serialNumber = serialNumber;
        this.iscsiIQN = iscsiIQN;
        this.label = label;
        this.lifecycleState = lifecycleState;
        this.attachedTransferPackageLabel = attachedTransferPackageLabel;
        this.creationTime = creationTime;
        this.uploadStatusLogUri = uploadStatusLogUri;
    }

    public static enum LifecycleState {
        Preparing("PREPARING"),
        Ready("READY"),
        Packaged("PACKAGED"),
        Active("ACTIVE"),
        Processing("PROCESSING"),
        Complete("COMPLETE"),
        Missing("MISSING"),
        Error("ERROR"),
        Deleted("DELETED"),
        Cancelled("CANCELLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="iscsiIQN")
        private String iscsiIQN;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="attachedTransferPackageLabel")
        private String attachedTransferPackageLabel;
        @JsonProperty(value="creationTime")
        private Date creationTime;
        @JsonProperty(value="uploadStatusLogUri")
        private String uploadStatusLogUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder iscsiIQN(String iscsiIQN) {
            this.iscsiIQN = iscsiIQN;
            this.__explicitlySet__.add("iscsiIQN");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder attachedTransferPackageLabel(String attachedTransferPackageLabel) {
            this.attachedTransferPackageLabel = attachedTransferPackageLabel;
            this.__explicitlySet__.add("attachedTransferPackageLabel");
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            this.__explicitlySet__.add("creationTime");
            return this;
        }

        public Builder uploadStatusLogUri(String uploadStatusLogUri) {
            this.uploadStatusLogUri = uploadStatusLogUri;
            this.__explicitlySet__.add("uploadStatusLogUri");
            return this;
        }

        public TransferDeviceSummary build() {
            TransferDeviceSummary __instance__ = new TransferDeviceSummary(this.serialNumber, this.iscsiIQN, this.label, this.lifecycleState, this.attachedTransferPackageLabel, this.creationTime, this.uploadStatusLogUri);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(TransferDeviceSummary o) {
            Builder copiedBuilder = this.serialNumber(o.getSerialNumber()).iscsiIQN(o.getIscsiIQN()).label(o.getLabel()).lifecycleState(o.getLifecycleState()).attachedTransferPackageLabel(o.getAttachedTransferPackageLabel()).creationTime(o.getCreationTime()).uploadStatusLogUri(o.getUploadStatusLogUri());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "TransferDeviceSummary.Builder(serialNumber=" + this.serialNumber + ", iscsiIQN=" + this.iscsiIQN + ", label=" + this.label + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", attachedTransferPackageLabel=" + this.attachedTransferPackageLabel + ", creationTime=" + this.creationTime + ", uploadStatusLogUri=" + this.uploadStatusLogUri + ")";
        }
    }
}

