/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteTransferDeviceRequest
extends BmcRequest<Void> {
    private String id;
    private String transferDeviceLabel;

    @ConstructorProperties(value={"id", "transferDeviceLabel"})
    DeleteTransferDeviceRequest(String id, String transferDeviceLabel) {
        this.id = id;
        this.transferDeviceLabel = transferDeviceLabel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTransferDeviceLabel() {
        return this.transferDeviceLabel;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteTransferDeviceRequest, Void> {
        private String id;
        private String transferDeviceLabel;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteTransferDeviceRequest o) {
            this.id(o.getId());
            this.transferDeviceLabel(o.getTransferDeviceLabel());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteTransferDeviceRequest build() {
            DeleteTransferDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferDeviceLabel(String transferDeviceLabel) {
            this.transferDeviceLabel = transferDeviceLabel;
            return this;
        }

        public DeleteTransferDeviceRequest buildWithoutInvocationCallback() {
            return new DeleteTransferDeviceRequest(this.id, this.transferDeviceLabel);
        }

        public String toString() {
            return "DeleteTransferDeviceRequest.Builder(id=" + this.id + ", transferDeviceLabel=" + this.transferDeviceLabel + ")";
        }
    }
}

