/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.TransferAppliancePublicKey;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTransferApplianceAdminCredentialsRequest
extends BmcRequest<TransferAppliancePublicKey> {
    private String id;
    private String transferApplianceLabel;
    private TransferAppliancePublicKey adminPublicKey;
    private String opcRetryToken;

    public String getId() {
        return this.id;
    }

    public String getTransferApplianceLabel() {
        return this.transferApplianceLabel;
    }

    public TransferAppliancePublicKey getAdminPublicKey() {
        return this.adminPublicKey;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public TransferAppliancePublicKey getBody$() {
        return this.adminPublicKey;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).transferApplianceLabel(this.transferApplianceLabel).adminPublicKey(this.adminPublicKey).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",transferApplianceLabel=").append(String.valueOf(this.transferApplianceLabel));
        sb.append(",adminPublicKey=").append(String.valueOf((Object)this.adminPublicKey));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTransferApplianceAdminCredentialsRequest)) {
            return false;
        }
        CreateTransferApplianceAdminCredentialsRequest other = (CreateTransferApplianceAdminCredentialsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.transferApplianceLabel, other.transferApplianceLabel) && Objects.equals((Object)this.adminPublicKey, (Object)other.adminPublicKey) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.transferApplianceLabel == null ? 43 : this.transferApplianceLabel.hashCode());
        result = result * 59 + (this.adminPublicKey == null ? 43 : this.adminPublicKey.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTransferApplianceAdminCredentialsRequest, TransferAppliancePublicKey> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String transferApplianceLabel = null;
        private TransferAppliancePublicKey adminPublicKey = null;
        private String opcRetryToken = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferApplianceLabel(String transferApplianceLabel) {
            this.transferApplianceLabel = transferApplianceLabel;
            return this;
        }

        public Builder adminPublicKey(TransferAppliancePublicKey adminPublicKey) {
            this.adminPublicKey = adminPublicKey;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferApplianceAdminCredentialsRequest o) {
            this.id(o.getId());
            this.transferApplianceLabel(o.getTransferApplianceLabel());
            this.adminPublicKey(o.getAdminPublicKey());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferApplianceAdminCredentialsRequest build() {
            CreateTransferApplianceAdminCredentialsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TransferAppliancePublicKey body) {
            this.adminPublicKey(body);
            return this;
        }

        public CreateTransferApplianceAdminCredentialsRequest buildWithoutInvocationCallback() {
            CreateTransferApplianceAdminCredentialsRequest request = new CreateTransferApplianceAdminCredentialsRequest();
            request.id = this.id;
            request.transferApplianceLabel = this.transferApplianceLabel;
            request.adminPublicKey = this.adminPublicKey;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

