/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.ApplianceExportJob;
import com.oracle.bmc.dts.ApplianceExportJobPaginators;
import com.oracle.bmc.dts.ApplianceExportJobWaiters;
import com.oracle.bmc.dts.model.ApplianceExportJobSummary;
import com.oracle.bmc.dts.requests.ChangeApplianceExportJobCompartmentRequest;
import com.oracle.bmc.dts.requests.CreateApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.DeleteApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.GetApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.ListApplianceExportJobsRequest;
import com.oracle.bmc.dts.requests.UpdateApplianceExportJobRequest;
import com.oracle.bmc.dts.responses.ChangeApplianceExportJobCompartmentResponse;
import com.oracle.bmc.dts.responses.CreateApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.DeleteApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.GetApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.ListApplianceExportJobsResponse;
import com.oracle.bmc.dts.responses.UpdateApplianceExportJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplianceExportJobClient
extends BaseSyncClient
implements ApplianceExportJob {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLIANCEEXPORTJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApplianceExportJobClient.class);
    private final ApplianceExportJobWaiters waiters;
    private final ApplianceExportJobPaginators paginators;

    ApplianceExportJobClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ApplianceExportJob-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApplianceExportJobWaiters(executorService, this);
        this.paginators = new ApplianceExportJobPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeApplianceExportJobCompartmentResponse changeApplianceExportJobCompartment(ChangeApplianceExportJobCompartmentRequest request) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApplianceExportJobCompartmentDetails(), "changeApplianceExportJobCompartmentDetails is required");
        return (ChangeApplianceExportJobCompartmentResponse)this.clientCall(request, ChangeApplianceExportJobCompartmentResponse::builder).logger(LOG, "changeApplianceExportJobCompartment").serviceDetails("ApplianceExportJob", "ChangeApplianceExportJobCompartment", "").method(Method.POST).requestBuilder(ChangeApplianceExportJobCompartmentRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeApplianceExportJobCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateApplianceExportJobResponse createApplianceExportJob(CreateApplianceExportJobRequest request) {
        Objects.requireNonNull(request.getCreateApplianceExportJobDetails(), "createApplianceExportJobDetails is required");
        return (CreateApplianceExportJobResponse)this.clientCall(request, CreateApplianceExportJobResponse::builder).logger(LOG, "createApplianceExportJob").serviceDetails("ApplianceExportJob", "CreateApplianceExportJob", "").method(Method.POST).requestBuilder(CreateApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.dts.model.ApplianceExportJob.class, CreateApplianceExportJobResponse.Builder::applianceExportJob).handleResponseHeaderString("opc-request-id", CreateApplianceExportJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateApplianceExportJobResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteApplianceExportJobResponse deleteApplianceExportJob(DeleteApplianceExportJobRequest request) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        return (DeleteApplianceExportJobResponse)this.clientCall(request, DeleteApplianceExportJobResponse::builder).logger(LOG, "deleteApplianceExportJob").serviceDetails("ApplianceExportJob", "DeleteApplianceExportJob", "").method(Method.DELETE).requestBuilder(DeleteApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteApplianceExportJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetApplianceExportJobResponse getApplianceExportJob(GetApplianceExportJobRequest request) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        return (GetApplianceExportJobResponse)this.clientCall(request, GetApplianceExportJobResponse::builder).logger(LOG, "getApplianceExportJob").serviceDetails("ApplianceExportJob", "GetApplianceExportJob", "").method(Method.GET).requestBuilder(GetApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.dts.model.ApplianceExportJob.class, GetApplianceExportJobResponse.Builder::applianceExportJob).handleResponseHeaderString("opc-request-id", GetApplianceExportJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetApplianceExportJobResponse.Builder::etag).callSync();
    }

    @Override
    public ListApplianceExportJobsResponse listApplianceExportJobs(ListApplianceExportJobsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListApplianceExportJobsResponse)this.clientCall(request, ListApplianceExportJobsResponse::builder).logger(LOG, "listApplianceExportJobs").serviceDetails("ApplianceExportJob", "ListApplianceExportJobs", "").method(Method.GET).requestBuilder(ListApplianceExportJobsRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ApplianceExportJobSummary.class, ListApplianceExportJobsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListApplianceExportJobsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListApplianceExportJobsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateApplianceExportJobResponse updateApplianceExportJob(UpdateApplianceExportJobRequest request) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApplianceExportJobDetails(), "updateApplianceExportJobDetails is required");
        return (UpdateApplianceExportJobResponse)this.clientCall(request, UpdateApplianceExportJobResponse::builder).logger(LOG, "updateApplianceExportJob").serviceDetails("ApplianceExportJob", "UpdateApplianceExportJob", "").method(Method.PUT).requestBuilder(UpdateApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.dts.model.ApplianceExportJob.class, UpdateApplianceExportJobResponse.Builder::applianceExportJob).handleResponseHeaderString("opc-request-id", UpdateApplianceExportJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateApplianceExportJobResponse.Builder::etag).callSync();
    }

    @Override
    public ApplianceExportJobWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApplianceExportJobPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ApplianceExportJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApplianceExportJobClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplianceExportJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApplianceExportJobClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplianceExportJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApplianceExportJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplianceExportJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApplianceExportJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplianceExportJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApplianceExportJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplianceExportJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApplianceExportJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplianceExportJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplianceExportJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplianceExportJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplianceExportJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplianceExportJobClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "dts";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"dts");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApplianceExportJobClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApplianceExportJobClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

