/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferApplianceEntitlementAsync;
import com.oracle.bmc.dts.model.TransferApplianceEntitlement;
import com.oracle.bmc.dts.model.TransferApplianceEntitlementSummary;
import com.oracle.bmc.dts.requests.CreateTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.requests.ListTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceEntitlementResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEntitlementResponse;
import com.oracle.bmc.dts.responses.ListTransferApplianceEntitlementResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceEntitlementAsyncClient
extends BaseAsyncClient
implements TransferApplianceEntitlementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCEENTITLEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceEntitlementAsyncClient.class);

    TransferApplianceEntitlementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateTransferApplianceEntitlementResponse> createTransferApplianceEntitlement(CreateTransferApplianceEntitlementRequest request, AsyncHandler<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse> handler) {
        Objects.requireNonNull(request.getCreateTransferApplianceEntitlementDetails(), "createTransferApplianceEntitlementDetails is required");
        return this.clientCall(request, CreateTransferApplianceEntitlementResponse::builder).logger(LOG, "createTransferApplianceEntitlement").serviceDetails("TransferApplianceEntitlement", "CreateTransferApplianceEntitlement", "").method(Method.POST).requestBuilder(CreateTransferApplianceEntitlementRequest::builder).basePath("/20171001").appendPathParam("transferApplianceEntitlement").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TransferApplianceEntitlement.class, CreateTransferApplianceEntitlementResponse.Builder::transferApplianceEntitlement).handleResponseHeaderString("opc-request-id", CreateTransferApplianceEntitlementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferApplianceEntitlementResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetTransferApplianceEntitlementResponse> getTransferApplianceEntitlement(GetTransferApplianceEntitlementRequest request, AsyncHandler<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTransferApplianceEntitlementResponse::builder).logger(LOG, "getTransferApplianceEntitlement").serviceDetails("TransferApplianceEntitlement", "GetTransferApplianceEntitlement", "").method(Method.GET).requestBuilder(GetTransferApplianceEntitlementRequest::builder).basePath("/20171001").appendPathParam("transferApplianceEntitlement").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TransferApplianceEntitlement.class, GetTransferApplianceEntitlementResponse.Builder::transferApplianceEntitlement).handleResponseHeaderString("opc-request-id", GetTransferApplianceEntitlementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListTransferApplianceEntitlementResponse> listTransferApplianceEntitlement(ListTransferApplianceEntitlementRequest request, AsyncHandler<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListTransferApplianceEntitlementResponse::builder).logger(LOG, "listTransferApplianceEntitlement").serviceDetails("TransferApplianceEntitlement", "ListTransferApplianceEntitlement", "").method(Method.GET).requestBuilder(ListTransferApplianceEntitlementRequest::builder).basePath("/20171001").appendPathParam("transferApplianceEntitlement").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(TransferApplianceEntitlementSummary.class, ListTransferApplianceEntitlementResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTransferApplianceEntitlementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public TransferApplianceEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferApplianceEntitlementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferApplianceEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferApplianceEntitlementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferApplianceEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferApplianceEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferApplianceEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferApplianceEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferApplianceEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferApplianceEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceEntitlementAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "dts";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"dts");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TransferApplianceEntitlementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferApplianceEntitlementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

