/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferPackageWaiters;
import com.oracle.bmc.dts.model.MultipleTransferPackages;
import com.oracle.bmc.dts.model.TransferPackage;
import com.oracle.bmc.dts.requests.AttachDevicesToTransferPackageRequest;
import com.oracle.bmc.dts.requests.CreateTransferPackageRequest;
import com.oracle.bmc.dts.requests.DeleteTransferPackageRequest;
import com.oracle.bmc.dts.requests.DetachDevicesFromTransferPackageRequest;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.requests.ListTransferPackagesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferPackageRequest;
import com.oracle.bmc.dts.responses.AttachDevicesToTransferPackageResponse;
import com.oracle.bmc.dts.responses.CreateTransferPackageResponse;
import com.oracle.bmc.dts.responses.DeleteTransferPackageResponse;
import com.oracle.bmc.dts.responses.DetachDevicesFromTransferPackageResponse;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.dts.responses.ListTransferPackagesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferPackageResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferPackageClient
extends BaseSyncClient
implements com.oracle.bmc.dts.TransferPackage {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERPACKAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferPackageClient.class);
    private final TransferPackageWaiters waiters;

    TransferPackageClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("TransferPackage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new TransferPackageWaiters(executorService, this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AttachDevicesToTransferPackageResponse attachDevicesToTransferPackage(AttachDevicesToTransferPackageRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachDevicesDetails(), "attachDevicesDetails is required");
        return (AttachDevicesToTransferPackageResponse)this.clientCall(request, AttachDevicesToTransferPackageResponse::builder).logger(LOG, "attachDevicesToTransferPackage").serviceDetails("TransferPackage", "AttachDevicesToTransferPackage", "").method(Method.POST).requestBuilder(AttachDevicesToTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).appendPathParam("actions").appendPathParam("attachDevices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AttachDevicesToTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AttachDevicesToTransferPackageResponse.Builder::etag).callSync();
    }

    @Override
    public CreateTransferPackageResponse createTransferPackage(CreateTransferPackageRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (CreateTransferPackageResponse)this.clientCall(request, CreateTransferPackageResponse::builder).logger(LOG, "createTransferPackage").serviceDetails("TransferPackage", "CreateTransferPackage", "").method(Method.POST).requestBuilder(CreateTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TransferPackage.class, CreateTransferPackageResponse.Builder::transferPackage).handleResponseHeaderString("opc-request-id", CreateTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferPackageResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteTransferPackageResponse deleteTransferPackage(DeleteTransferPackageRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        return (DeleteTransferPackageResponse)this.clientCall(request, DeleteTransferPackageResponse::builder).logger(LOG, "deleteTransferPackage").serviceDetails("TransferPackage", "DeleteTransferPackage", "").method(Method.DELETE).requestBuilder(DeleteTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteTransferPackageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachDevicesFromTransferPackageResponse detachDevicesFromTransferPackage(DetachDevicesFromTransferPackageRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachDevicesDetails(), "detachDevicesDetails is required");
        return (DetachDevicesFromTransferPackageResponse)this.clientCall(request, DetachDevicesFromTransferPackageResponse::builder).logger(LOG, "detachDevicesFromTransferPackage").serviceDetails("TransferPackage", "DetachDevicesFromTransferPackage", "").method(Method.POST).requestBuilder(DetachDevicesFromTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).appendPathParam("actions").appendPathParam("detachDevices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DetachDevicesFromTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DetachDevicesFromTransferPackageResponse.Builder::etag).callSync();
    }

    @Override
    public GetTransferPackageResponse getTransferPackage(GetTransferPackageRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        return (GetTransferPackageResponse)this.clientCall(request, GetTransferPackageResponse::builder).logger(LOG, "getTransferPackage").serviceDetails("TransferPackage", "GetTransferPackage", "").method(Method.GET).requestBuilder(GetTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).accept(new String[]{"application/json"}).handleBody(TransferPackage.class, GetTransferPackageResponse.Builder::transferPackage).handleResponseHeaderString("opc-request-id", GetTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferPackageResponse.Builder::etag).callSync();
    }

    @Override
    public ListTransferPackagesResponse listTransferPackages(ListTransferPackagesRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (ListTransferPackagesResponse)this.clientCall(request, ListTransferPackagesResponse::builder).logger(LOG, "listTransferPackages").serviceDetails("TransferPackage", "ListTransferPackages", "").method(Method.GET).requestBuilder(ListTransferPackagesRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).handleBody(MultipleTransferPackages.class, ListTransferPackagesResponse.Builder::multipleTransferPackages).handleResponseHeaderString("opc-request-id", ListTransferPackagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTransferPackageResponse updateTransferPackage(UpdateTransferPackageRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTransferPackageDetails(), "updateTransferPackageDetails is required");
        return (UpdateTransferPackageResponse)this.clientCall(request, UpdateTransferPackageResponse::builder).logger(LOG, "updateTransferPackage").serviceDetails("TransferPackage", "UpdateTransferPackage", "").method(Method.PUT).requestBuilder(UpdateTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(TransferPackage.class, UpdateTransferPackageResponse.Builder::transferPackage).handleResponseHeaderString("opc-request-id", UpdateTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTransferPackageResponse.Builder::etag).callSync();
    }

    @Override
    public TransferPackageWaiters getWaiters() {
        return this.waiters;
    }

    @Deprecated
    public TransferPackageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferPackageClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferPackageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferPackageClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferPackageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferPackageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferPackageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferPackageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferPackageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferPackageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferPackageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferPackageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferPackageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "dts";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"dts");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public TransferPackageClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferPackageClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

