/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dts.model.ShippingAddress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApplianceExportJob
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="creationTime")
    private final Date creationTime;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="applianceSerialNumber")
    private final String applianceSerialNumber;
    @JsonProperty(value="applianceDecryptionPassphrase")
    private final String applianceDecryptionPassphrase;
    @JsonProperty(value="applianceDeliveryVendor")
    private final String applianceDeliveryVendor;
    @JsonProperty(value="applianceDeliveryTrackingNumber")
    private final String applianceDeliveryTrackingNumber;
    @JsonProperty(value="applianceReturnDeliveryTrackingNumber")
    private final String applianceReturnDeliveryTrackingNumber;
    @JsonProperty(value="sendingSecurityTie")
    private final String sendingSecurityTie;
    @JsonProperty(value="receivingSecurityTie")
    private final String receivingSecurityTie;
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonProperty(value="rangeStart")
    private final String rangeStart;
    @JsonProperty(value="rangeEnd")
    private final String rangeEnd;
    @JsonProperty(value="numberOfObjects")
    private final String numberOfObjects;
    @JsonProperty(value="totalSizeInBytes")
    private final String totalSizeInBytes;
    @JsonProperty(value="firstObject")
    private final String firstObject;
    @JsonProperty(value="lastObject")
    private final String lastObject;
    @JsonProperty(value="nextObject")
    private final String nextObject;
    @JsonProperty(value="manifestFile")
    private final String manifestFile;
    @JsonProperty(value="manifestMd5")
    private final String manifestMd5;
    @JsonProperty(value="bucketAccessPolicies")
    private final List<String> bucketAccessPolicies;
    @JsonProperty(value="returnShippingLabelUri")
    private final String returnShippingLabelUri;
    @JsonProperty(value="expectedReturnDate")
    private final Date expectedReturnDate;
    @JsonProperty(value="pickupWindowStartTime")
    private final Date pickupWindowStartTime;
    @JsonProperty(value="pickupWindowEndTime")
    private final Date pickupWindowEndTime;
    @JsonProperty(value="customerShippingAddress")
    private final ShippingAddress customerShippingAddress;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "bucketName", "displayName", "creationTime", "lifecycleState", "lifecycleStateDetails", "applianceSerialNumber", "applianceDecryptionPassphrase", "applianceDeliveryVendor", "applianceDeliveryTrackingNumber", "applianceReturnDeliveryTrackingNumber", "sendingSecurityTie", "receivingSecurityTie", "prefix", "rangeStart", "rangeEnd", "numberOfObjects", "totalSizeInBytes", "firstObject", "lastObject", "nextObject", "manifestFile", "manifestMd5", "bucketAccessPolicies", "returnShippingLabelUri", "expectedReturnDate", "pickupWindowStartTime", "pickupWindowEndTime", "customerShippingAddress", "freeformTags", "definedTags"})
    public ApplianceExportJob(String id, String compartmentId, String bucketName, String displayName, Date creationTime, LifecycleState lifecycleState, String lifecycleStateDetails, String applianceSerialNumber, String applianceDecryptionPassphrase, String applianceDeliveryVendor, String applianceDeliveryTrackingNumber, String applianceReturnDeliveryTrackingNumber, String sendingSecurityTie, String receivingSecurityTie, String prefix, String rangeStart, String rangeEnd, String numberOfObjects, String totalSizeInBytes, String firstObject, String lastObject, String nextObject, String manifestFile, String manifestMd5, List<String> bucketAccessPolicies, String returnShippingLabelUri, Date expectedReturnDate, Date pickupWindowStartTime, Date pickupWindowEndTime, ShippingAddress customerShippingAddress, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.bucketName = bucketName;
        this.displayName = displayName;
        this.creationTime = creationTime;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.applianceSerialNumber = applianceSerialNumber;
        this.applianceDecryptionPassphrase = applianceDecryptionPassphrase;
        this.applianceDeliveryVendor = applianceDeliveryVendor;
        this.applianceDeliveryTrackingNumber = applianceDeliveryTrackingNumber;
        this.applianceReturnDeliveryTrackingNumber = applianceReturnDeliveryTrackingNumber;
        this.sendingSecurityTie = sendingSecurityTie;
        this.receivingSecurityTie = receivingSecurityTie;
        this.prefix = prefix;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.numberOfObjects = numberOfObjects;
        this.totalSizeInBytes = totalSizeInBytes;
        this.firstObject = firstObject;
        this.lastObject = lastObject;
        this.nextObject = nextObject;
        this.manifestFile = manifestFile;
        this.manifestMd5 = manifestMd5;
        this.bucketAccessPolicies = bucketAccessPolicies;
        this.returnShippingLabelUri = returnShippingLabelUri;
        this.expectedReturnDate = expectedReturnDate;
        this.pickupWindowStartTime = pickupWindowStartTime;
        this.pickupWindowEndTime = pickupWindowEndTime;
        this.customerShippingAddress = customerShippingAddress;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public String getApplianceSerialNumber() {
        return this.applianceSerialNumber;
    }

    public String getApplianceDecryptionPassphrase() {
        return this.applianceDecryptionPassphrase;
    }

    public String getApplianceDeliveryVendor() {
        return this.applianceDeliveryVendor;
    }

    public String getApplianceDeliveryTrackingNumber() {
        return this.applianceDeliveryTrackingNumber;
    }

    public String getApplianceReturnDeliveryTrackingNumber() {
        return this.applianceReturnDeliveryTrackingNumber;
    }

    public String getSendingSecurityTie() {
        return this.sendingSecurityTie;
    }

    public String getReceivingSecurityTie() {
        return this.receivingSecurityTie;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRangeStart() {
        return this.rangeStart;
    }

    public String getRangeEnd() {
        return this.rangeEnd;
    }

    public String getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public String getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public String getFirstObject() {
        return this.firstObject;
    }

    public String getLastObject() {
        return this.lastObject;
    }

    public String getNextObject() {
        return this.nextObject;
    }

    public String getManifestFile() {
        return this.manifestFile;
    }

    public String getManifestMd5() {
        return this.manifestMd5;
    }

    public List<String> getBucketAccessPolicies() {
        return this.bucketAccessPolicies;
    }

    public String getReturnShippingLabelUri() {
        return this.returnShippingLabelUri;
    }

    public Date getExpectedReturnDate() {
        return this.expectedReturnDate;
    }

    public Date getPickupWindowStartTime() {
        return this.pickupWindowStartTime;
    }

    public Date getPickupWindowEndTime() {
        return this.pickupWindowEndTime;
    }

    public ShippingAddress getCustomerShippingAddress() {
        return this.customerShippingAddress;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplianceExportJob(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", creationTime=").append(String.valueOf(this.creationTime));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleStateDetails=").append(String.valueOf(this.lifecycleStateDetails));
        sb.append(", applianceSerialNumber=").append(String.valueOf(this.applianceSerialNumber));
        sb.append(", applianceDecryptionPassphrase=").append(String.valueOf(this.applianceDecryptionPassphrase));
        sb.append(", applianceDeliveryVendor=").append(String.valueOf(this.applianceDeliveryVendor));
        sb.append(", applianceDeliveryTrackingNumber=").append(String.valueOf(this.applianceDeliveryTrackingNumber));
        sb.append(", applianceReturnDeliveryTrackingNumber=").append(String.valueOf(this.applianceReturnDeliveryTrackingNumber));
        sb.append(", sendingSecurityTie=").append(String.valueOf(this.sendingSecurityTie));
        sb.append(", receivingSecurityTie=").append(String.valueOf(this.receivingSecurityTie));
        sb.append(", prefix=").append(String.valueOf(this.prefix));
        sb.append(", rangeStart=").append(String.valueOf(this.rangeStart));
        sb.append(", rangeEnd=").append(String.valueOf(this.rangeEnd));
        sb.append(", numberOfObjects=").append(String.valueOf(this.numberOfObjects));
        sb.append(", totalSizeInBytes=").append(String.valueOf(this.totalSizeInBytes));
        sb.append(", firstObject=").append(String.valueOf(this.firstObject));
        sb.append(", lastObject=").append(String.valueOf(this.lastObject));
        sb.append(", nextObject=").append(String.valueOf(this.nextObject));
        sb.append(", manifestFile=").append(String.valueOf(this.manifestFile));
        sb.append(", manifestMd5=").append(String.valueOf(this.manifestMd5));
        sb.append(", bucketAccessPolicies=").append(String.valueOf(this.bucketAccessPolicies));
        sb.append(", returnShippingLabelUri=").append(String.valueOf(this.returnShippingLabelUri));
        sb.append(", expectedReturnDate=").append(String.valueOf(this.expectedReturnDate));
        sb.append(", pickupWindowStartTime=").append(String.valueOf(this.pickupWindowStartTime));
        sb.append(", pickupWindowEndTime=").append(String.valueOf(this.pickupWindowEndTime));
        sb.append(", customerShippingAddress=").append(String.valueOf((Object)this.customerShippingAddress));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplianceExportJob)) {
            return false;
        }
        ApplianceExportJob other = (ApplianceExportJob)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.creationTime, other.creationTime) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleStateDetails, other.lifecycleStateDetails) && Objects.equals(this.applianceSerialNumber, other.applianceSerialNumber) && Objects.equals(this.applianceDecryptionPassphrase, other.applianceDecryptionPassphrase) && Objects.equals(this.applianceDeliveryVendor, other.applianceDeliveryVendor) && Objects.equals(this.applianceDeliveryTrackingNumber, other.applianceDeliveryTrackingNumber) && Objects.equals(this.applianceReturnDeliveryTrackingNumber, other.applianceReturnDeliveryTrackingNumber) && Objects.equals(this.sendingSecurityTie, other.sendingSecurityTie) && Objects.equals(this.receivingSecurityTie, other.receivingSecurityTie) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.rangeStart, other.rangeStart) && Objects.equals(this.rangeEnd, other.rangeEnd) && Objects.equals(this.numberOfObjects, other.numberOfObjects) && Objects.equals(this.totalSizeInBytes, other.totalSizeInBytes) && Objects.equals(this.firstObject, other.firstObject) && Objects.equals(this.lastObject, other.lastObject) && Objects.equals(this.nextObject, other.nextObject) && Objects.equals(this.manifestFile, other.manifestFile) && Objects.equals(this.manifestMd5, other.manifestMd5) && Objects.equals(this.bucketAccessPolicies, other.bucketAccessPolicies) && Objects.equals(this.returnShippingLabelUri, other.returnShippingLabelUri) && Objects.equals(this.expectedReturnDate, other.expectedReturnDate) && Objects.equals(this.pickupWindowStartTime, other.pickupWindowStartTime) && Objects.equals(this.pickupWindowEndTime, other.pickupWindowEndTime) && Objects.equals((Object)this.customerShippingAddress, (Object)other.customerShippingAddress) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.creationTime == null ? 43 : this.creationTime.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleStateDetails == null ? 43 : this.lifecycleStateDetails.hashCode());
        result = result * 59 + (this.applianceSerialNumber == null ? 43 : this.applianceSerialNumber.hashCode());
        result = result * 59 + (this.applianceDecryptionPassphrase == null ? 43 : this.applianceDecryptionPassphrase.hashCode());
        result = result * 59 + (this.applianceDeliveryVendor == null ? 43 : this.applianceDeliveryVendor.hashCode());
        result = result * 59 + (this.applianceDeliveryTrackingNumber == null ? 43 : this.applianceDeliveryTrackingNumber.hashCode());
        result = result * 59 + (this.applianceReturnDeliveryTrackingNumber == null ? 43 : this.applianceReturnDeliveryTrackingNumber.hashCode());
        result = result * 59 + (this.sendingSecurityTie == null ? 43 : this.sendingSecurityTie.hashCode());
        result = result * 59 + (this.receivingSecurityTie == null ? 43 : this.receivingSecurityTie.hashCode());
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + (this.rangeStart == null ? 43 : this.rangeStart.hashCode());
        result = result * 59 + (this.rangeEnd == null ? 43 : this.rangeEnd.hashCode());
        result = result * 59 + (this.numberOfObjects == null ? 43 : this.numberOfObjects.hashCode());
        result = result * 59 + (this.totalSizeInBytes == null ? 43 : this.totalSizeInBytes.hashCode());
        result = result * 59 + (this.firstObject == null ? 43 : this.firstObject.hashCode());
        result = result * 59 + (this.lastObject == null ? 43 : this.lastObject.hashCode());
        result = result * 59 + (this.nextObject == null ? 43 : this.nextObject.hashCode());
        result = result * 59 + (this.manifestFile == null ? 43 : this.manifestFile.hashCode());
        result = result * 59 + (this.manifestMd5 == null ? 43 : this.manifestMd5.hashCode());
        result = result * 59 + (this.bucketAccessPolicies == null ? 43 : this.bucketAccessPolicies.hashCode());
        result = result * 59 + (this.returnShippingLabelUri == null ? 43 : this.returnShippingLabelUri.hashCode());
        result = result * 59 + (this.expectedReturnDate == null ? 43 : this.expectedReturnDate.hashCode());
        result = result * 59 + (this.pickupWindowStartTime == null ? 43 : this.pickupWindowStartTime.hashCode());
        result = result * 59 + (this.pickupWindowEndTime == null ? 43 : this.pickupWindowEndTime.hashCode());
        result = result * 59 + (this.customerShippingAddress == null ? 43 : this.customerShippingAddress.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inprogress("INPROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Cancelled("CANCELLED"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="creationTime")
        private Date creationTime;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="applianceSerialNumber")
        private String applianceSerialNumber;
        @JsonProperty(value="applianceDecryptionPassphrase")
        private String applianceDecryptionPassphrase;
        @JsonProperty(value="applianceDeliveryVendor")
        private String applianceDeliveryVendor;
        @JsonProperty(value="applianceDeliveryTrackingNumber")
        private String applianceDeliveryTrackingNumber;
        @JsonProperty(value="applianceReturnDeliveryTrackingNumber")
        private String applianceReturnDeliveryTrackingNumber;
        @JsonProperty(value="sendingSecurityTie")
        private String sendingSecurityTie;
        @JsonProperty(value="receivingSecurityTie")
        private String receivingSecurityTie;
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonProperty(value="rangeStart")
        private String rangeStart;
        @JsonProperty(value="rangeEnd")
        private String rangeEnd;
        @JsonProperty(value="numberOfObjects")
        private String numberOfObjects;
        @JsonProperty(value="totalSizeInBytes")
        private String totalSizeInBytes;
        @JsonProperty(value="firstObject")
        private String firstObject;
        @JsonProperty(value="lastObject")
        private String lastObject;
        @JsonProperty(value="nextObject")
        private String nextObject;
        @JsonProperty(value="manifestFile")
        private String manifestFile;
        @JsonProperty(value="manifestMd5")
        private String manifestMd5;
        @JsonProperty(value="bucketAccessPolicies")
        private List<String> bucketAccessPolicies;
        @JsonProperty(value="returnShippingLabelUri")
        private String returnShippingLabelUri;
        @JsonProperty(value="expectedReturnDate")
        private Date expectedReturnDate;
        @JsonProperty(value="pickupWindowStartTime")
        private Date pickupWindowStartTime;
        @JsonProperty(value="pickupWindowEndTime")
        private Date pickupWindowEndTime;
        @JsonProperty(value="customerShippingAddress")
        private ShippingAddress customerShippingAddress;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            this.__explicitlySet__.add("creationTime");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder applianceSerialNumber(String applianceSerialNumber) {
            this.applianceSerialNumber = applianceSerialNumber;
            this.__explicitlySet__.add("applianceSerialNumber");
            return this;
        }

        public Builder applianceDecryptionPassphrase(String applianceDecryptionPassphrase) {
            this.applianceDecryptionPassphrase = applianceDecryptionPassphrase;
            this.__explicitlySet__.add("applianceDecryptionPassphrase");
            return this;
        }

        public Builder applianceDeliveryVendor(String applianceDeliveryVendor) {
            this.applianceDeliveryVendor = applianceDeliveryVendor;
            this.__explicitlySet__.add("applianceDeliveryVendor");
            return this;
        }

        public Builder applianceDeliveryTrackingNumber(String applianceDeliveryTrackingNumber) {
            this.applianceDeliveryTrackingNumber = applianceDeliveryTrackingNumber;
            this.__explicitlySet__.add("applianceDeliveryTrackingNumber");
            return this;
        }

        public Builder applianceReturnDeliveryTrackingNumber(String applianceReturnDeliveryTrackingNumber) {
            this.applianceReturnDeliveryTrackingNumber = applianceReturnDeliveryTrackingNumber;
            this.__explicitlySet__.add("applianceReturnDeliveryTrackingNumber");
            return this;
        }

        public Builder sendingSecurityTie(String sendingSecurityTie) {
            this.sendingSecurityTie = sendingSecurityTie;
            this.__explicitlySet__.add("sendingSecurityTie");
            return this;
        }

        public Builder receivingSecurityTie(String receivingSecurityTie) {
            this.receivingSecurityTie = receivingSecurityTie;
            this.__explicitlySet__.add("receivingSecurityTie");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public Builder rangeStart(String rangeStart) {
            this.rangeStart = rangeStart;
            this.__explicitlySet__.add("rangeStart");
            return this;
        }

        public Builder rangeEnd(String rangeEnd) {
            this.rangeEnd = rangeEnd;
            this.__explicitlySet__.add("rangeEnd");
            return this;
        }

        public Builder numberOfObjects(String numberOfObjects) {
            this.numberOfObjects = numberOfObjects;
            this.__explicitlySet__.add("numberOfObjects");
            return this;
        }

        public Builder totalSizeInBytes(String totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            this.__explicitlySet__.add("totalSizeInBytes");
            return this;
        }

        public Builder firstObject(String firstObject) {
            this.firstObject = firstObject;
            this.__explicitlySet__.add("firstObject");
            return this;
        }

        public Builder lastObject(String lastObject) {
            this.lastObject = lastObject;
            this.__explicitlySet__.add("lastObject");
            return this;
        }

        public Builder nextObject(String nextObject) {
            this.nextObject = nextObject;
            this.__explicitlySet__.add("nextObject");
            return this;
        }

        public Builder manifestFile(String manifestFile) {
            this.manifestFile = manifestFile;
            this.__explicitlySet__.add("manifestFile");
            return this;
        }

        public Builder manifestMd5(String manifestMd5) {
            this.manifestMd5 = manifestMd5;
            this.__explicitlySet__.add("manifestMd5");
            return this;
        }

        public Builder bucketAccessPolicies(List<String> bucketAccessPolicies) {
            this.bucketAccessPolicies = bucketAccessPolicies;
            this.__explicitlySet__.add("bucketAccessPolicies");
            return this;
        }

        public Builder returnShippingLabelUri(String returnShippingLabelUri) {
            this.returnShippingLabelUri = returnShippingLabelUri;
            this.__explicitlySet__.add("returnShippingLabelUri");
            return this;
        }

        public Builder expectedReturnDate(Date expectedReturnDate) {
            this.expectedReturnDate = expectedReturnDate;
            this.__explicitlySet__.add("expectedReturnDate");
            return this;
        }

        public Builder pickupWindowStartTime(Date pickupWindowStartTime) {
            this.pickupWindowStartTime = pickupWindowStartTime;
            this.__explicitlySet__.add("pickupWindowStartTime");
            return this;
        }

        public Builder pickupWindowEndTime(Date pickupWindowEndTime) {
            this.pickupWindowEndTime = pickupWindowEndTime;
            this.__explicitlySet__.add("pickupWindowEndTime");
            return this;
        }

        public Builder customerShippingAddress(ShippingAddress customerShippingAddress) {
            this.customerShippingAddress = customerShippingAddress;
            this.__explicitlySet__.add("customerShippingAddress");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public ApplianceExportJob build() {
            ApplianceExportJob model = new ApplianceExportJob(this.id, this.compartmentId, this.bucketName, this.displayName, this.creationTime, this.lifecycleState, this.lifecycleStateDetails, this.applianceSerialNumber, this.applianceDecryptionPassphrase, this.applianceDeliveryVendor, this.applianceDeliveryTrackingNumber, this.applianceReturnDeliveryTrackingNumber, this.sendingSecurityTie, this.receivingSecurityTie, this.prefix, this.rangeStart, this.rangeEnd, this.numberOfObjects, this.totalSizeInBytes, this.firstObject, this.lastObject, this.nextObject, this.manifestFile, this.manifestMd5, this.bucketAccessPolicies, this.returnShippingLabelUri, this.expectedReturnDate, this.pickupWindowStartTime, this.pickupWindowEndTime, this.customerShippingAddress, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApplianceExportJob model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("creationTime")) {
                this.creationTime(model.getCreationTime());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStateDetails")) {
                this.lifecycleStateDetails(model.getLifecycleStateDetails());
            }
            if (model.wasPropertyExplicitlySet("applianceSerialNumber")) {
                this.applianceSerialNumber(model.getApplianceSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("applianceDecryptionPassphrase")) {
                this.applianceDecryptionPassphrase(model.getApplianceDecryptionPassphrase());
            }
            if (model.wasPropertyExplicitlySet("applianceDeliveryVendor")) {
                this.applianceDeliveryVendor(model.getApplianceDeliveryVendor());
            }
            if (model.wasPropertyExplicitlySet("applianceDeliveryTrackingNumber")) {
                this.applianceDeliveryTrackingNumber(model.getApplianceDeliveryTrackingNumber());
            }
            if (model.wasPropertyExplicitlySet("applianceReturnDeliveryTrackingNumber")) {
                this.applianceReturnDeliveryTrackingNumber(model.getApplianceReturnDeliveryTrackingNumber());
            }
            if (model.wasPropertyExplicitlySet("sendingSecurityTie")) {
                this.sendingSecurityTie(model.getSendingSecurityTie());
            }
            if (model.wasPropertyExplicitlySet("receivingSecurityTie")) {
                this.receivingSecurityTie(model.getReceivingSecurityTie());
            }
            if (model.wasPropertyExplicitlySet("prefix")) {
                this.prefix(model.getPrefix());
            }
            if (model.wasPropertyExplicitlySet("rangeStart")) {
                this.rangeStart(model.getRangeStart());
            }
            if (model.wasPropertyExplicitlySet("rangeEnd")) {
                this.rangeEnd(model.getRangeEnd());
            }
            if (model.wasPropertyExplicitlySet("numberOfObjects")) {
                this.numberOfObjects(model.getNumberOfObjects());
            }
            if (model.wasPropertyExplicitlySet("totalSizeInBytes")) {
                this.totalSizeInBytes(model.getTotalSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("firstObject")) {
                this.firstObject(model.getFirstObject());
            }
            if (model.wasPropertyExplicitlySet("lastObject")) {
                this.lastObject(model.getLastObject());
            }
            if (model.wasPropertyExplicitlySet("nextObject")) {
                this.nextObject(model.getNextObject());
            }
            if (model.wasPropertyExplicitlySet("manifestFile")) {
                this.manifestFile(model.getManifestFile());
            }
            if (model.wasPropertyExplicitlySet("manifestMd5")) {
                this.manifestMd5(model.getManifestMd5());
            }
            if (model.wasPropertyExplicitlySet("bucketAccessPolicies")) {
                this.bucketAccessPolicies(model.getBucketAccessPolicies());
            }
            if (model.wasPropertyExplicitlySet("returnShippingLabelUri")) {
                this.returnShippingLabelUri(model.getReturnShippingLabelUri());
            }
            if (model.wasPropertyExplicitlySet("expectedReturnDate")) {
                this.expectedReturnDate(model.getExpectedReturnDate());
            }
            if (model.wasPropertyExplicitlySet("pickupWindowStartTime")) {
                this.pickupWindowStartTime(model.getPickupWindowStartTime());
            }
            if (model.wasPropertyExplicitlySet("pickupWindowEndTime")) {
                this.pickupWindowEndTime(model.getPickupWindowEndTime());
            }
            if (model.wasPropertyExplicitlySet("customerShippingAddress")) {
                this.customerShippingAddress(model.getCustomerShippingAddress());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

