/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TransferJobSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="uploadBucketName")
    private final String uploadBucketName;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="deviceType")
    private final DeviceType deviceType;
    @JsonProperty(value="creationTime")
    private final Date creationTime;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "uploadBucketName", "displayName", "label", "deviceType", "creationTime", "lifecycleState", "freeformTags", "definedTags"})
    public TransferJobSummary(String id, String uploadBucketName, String displayName, String label, DeviceType deviceType, Date creationTime, LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.uploadBucketName = uploadBucketName;
        this.displayName = displayName;
        this.label = label;
        this.deviceType = deviceType;
        this.creationTime = creationTime;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getUploadBucketName() {
        return this.uploadBucketName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLabel() {
        return this.label;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TransferJobSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", uploadBucketName=").append(String.valueOf(this.uploadBucketName));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", label=").append(String.valueOf(this.label));
        sb.append(", deviceType=").append(String.valueOf((Object)this.deviceType));
        sb.append(", creationTime=").append(String.valueOf(this.creationTime));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferJobSummary)) {
            return false;
        }
        TransferJobSummary other = (TransferJobSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.uploadBucketName, other.uploadBucketName) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.label, other.label) && Objects.equals((Object)this.deviceType, (Object)other.deviceType) && Objects.equals(this.creationTime, other.creationTime) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.uploadBucketName == null ? 43 : this.uploadBucketName.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.deviceType == null ? 43 : this.deviceType.hashCode());
        result = result * 59 + (this.creationTime == null ? 43 : this.creationTime.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Initiated("INITIATED"),
        Preparing("PREPARING"),
        Active("ACTIVE"),
        Deleted("DELETED"),
        Closed("CLOSED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DeviceType implements BmcEnum
    {
        Disk("DISK"),
        Appliance("APPLIANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DeviceType> map;

        private DeviceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DeviceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DeviceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DeviceType.class);
            map = new HashMap<String, DeviceType>();
            for (DeviceType v : DeviceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="uploadBucketName")
        private String uploadBucketName;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="deviceType")
        private DeviceType deviceType;
        @JsonProperty(value="creationTime")
        private Date creationTime;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder uploadBucketName(String uploadBucketName) {
            this.uploadBucketName = uploadBucketName;
            this.__explicitlySet__.add("uploadBucketName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            this.__explicitlySet__.add("deviceType");
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            this.__explicitlySet__.add("creationTime");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public TransferJobSummary build() {
            TransferJobSummary model = new TransferJobSummary(this.id, this.uploadBucketName, this.displayName, this.label, this.deviceType, this.creationTime, this.lifecycleState, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TransferJobSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("uploadBucketName")) {
                this.uploadBucketName(model.getUploadBucketName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("deviceType")) {
                this.deviceType(model.getDeviceType());
            }
            if (model.wasPropertyExplicitlySet("creationTime")) {
                this.creationTime(model.getCreationTime());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

