/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TransferPackage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="transferJobId")
    private final String transferJobId;
    @JsonProperty(value="creationTime")
    private final Date creationTime;
    @JsonProperty(value="originalPackageDeliveryTrackingNumber")
    private final String originalPackageDeliveryTrackingNumber;
    @JsonProperty(value="returnPackageDeliveryTrackingNumber")
    private final String returnPackageDeliveryTrackingNumber;
    @JsonProperty(value="packageDeliveryVendor")
    private final String packageDeliveryVendor;
    @JsonProperty(value="transferSiteShippingAddress")
    private final String transferSiteShippingAddress;
    @JsonProperty(value="attachedTransferDeviceLabels")
    private final List<String> attachedTransferDeviceLabels;

    @Deprecated
    @ConstructorProperties(value={"label", "lifecycleState", "transferJobId", "creationTime", "originalPackageDeliveryTrackingNumber", "returnPackageDeliveryTrackingNumber", "packageDeliveryVendor", "transferSiteShippingAddress", "attachedTransferDeviceLabels"})
    public TransferPackage(String label, LifecycleState lifecycleState, String transferJobId, Date creationTime, String originalPackageDeliveryTrackingNumber, String returnPackageDeliveryTrackingNumber, String packageDeliveryVendor, String transferSiteShippingAddress, List<String> attachedTransferDeviceLabels) {
        this.label = label;
        this.lifecycleState = lifecycleState;
        this.transferJobId = transferJobId;
        this.creationTime = creationTime;
        this.originalPackageDeliveryTrackingNumber = originalPackageDeliveryTrackingNumber;
        this.returnPackageDeliveryTrackingNumber = returnPackageDeliveryTrackingNumber;
        this.packageDeliveryVendor = packageDeliveryVendor;
        this.transferSiteShippingAddress = transferSiteShippingAddress;
        this.attachedTransferDeviceLabels = attachedTransferDeviceLabels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLabel() {
        return this.label;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getTransferJobId() {
        return this.transferJobId;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getOriginalPackageDeliveryTrackingNumber() {
        return this.originalPackageDeliveryTrackingNumber;
    }

    public String getReturnPackageDeliveryTrackingNumber() {
        return this.returnPackageDeliveryTrackingNumber;
    }

    public String getPackageDeliveryVendor() {
        return this.packageDeliveryVendor;
    }

    public String getTransferSiteShippingAddress() {
        return this.transferSiteShippingAddress;
    }

    public List<String> getAttachedTransferDeviceLabels() {
        return this.attachedTransferDeviceLabels;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TransferPackage(");
        sb.append("super=").append(super.toString());
        sb.append("label=").append(String.valueOf(this.label));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", transferJobId=").append(String.valueOf(this.transferJobId));
        sb.append(", creationTime=").append(String.valueOf(this.creationTime));
        sb.append(", originalPackageDeliveryTrackingNumber=").append(String.valueOf(this.originalPackageDeliveryTrackingNumber));
        sb.append(", returnPackageDeliveryTrackingNumber=").append(String.valueOf(this.returnPackageDeliveryTrackingNumber));
        sb.append(", packageDeliveryVendor=").append(String.valueOf(this.packageDeliveryVendor));
        sb.append(", transferSiteShippingAddress=").append(String.valueOf(this.transferSiteShippingAddress));
        sb.append(", attachedTransferDeviceLabels=").append(String.valueOf(this.attachedTransferDeviceLabels));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferPackage)) {
            return false;
        }
        TransferPackage other = (TransferPackage)((Object)o);
        return Objects.equals(this.label, other.label) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.transferJobId, other.transferJobId) && Objects.equals(this.creationTime, other.creationTime) && Objects.equals(this.originalPackageDeliveryTrackingNumber, other.originalPackageDeliveryTrackingNumber) && Objects.equals(this.returnPackageDeliveryTrackingNumber, other.returnPackageDeliveryTrackingNumber) && Objects.equals(this.packageDeliveryVendor, other.packageDeliveryVendor) && Objects.equals(this.transferSiteShippingAddress, other.transferSiteShippingAddress) && Objects.equals(this.attachedTransferDeviceLabels, other.attachedTransferDeviceLabels) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.transferJobId == null ? 43 : this.transferJobId.hashCode());
        result = result * 59 + (this.creationTime == null ? 43 : this.creationTime.hashCode());
        result = result * 59 + (this.originalPackageDeliveryTrackingNumber == null ? 43 : this.originalPackageDeliveryTrackingNumber.hashCode());
        result = result * 59 + (this.returnPackageDeliveryTrackingNumber == null ? 43 : this.returnPackageDeliveryTrackingNumber.hashCode());
        result = result * 59 + (this.packageDeliveryVendor == null ? 43 : this.packageDeliveryVendor.hashCode());
        result = result * 59 + (this.transferSiteShippingAddress == null ? 43 : this.transferSiteShippingAddress.hashCode());
        result = result * 59 + (this.attachedTransferDeviceLabels == null ? 43 : this.attachedTransferDeviceLabels.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Preparing("PREPARING"),
        Shipping("SHIPPING"),
        Received("RECEIVED"),
        Processing("PROCESSING"),
        Processed("PROCESSED"),
        Returned("RETURNED"),
        Deleted("DELETED"),
        Cancelled("CANCELLED"),
        CancelledReturned("CANCELLED_RETURNED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="transferJobId")
        private String transferJobId;
        @JsonProperty(value="creationTime")
        private Date creationTime;
        @JsonProperty(value="originalPackageDeliveryTrackingNumber")
        private String originalPackageDeliveryTrackingNumber;
        @JsonProperty(value="returnPackageDeliveryTrackingNumber")
        private String returnPackageDeliveryTrackingNumber;
        @JsonProperty(value="packageDeliveryVendor")
        private String packageDeliveryVendor;
        @JsonProperty(value="transferSiteShippingAddress")
        private String transferSiteShippingAddress;
        @JsonProperty(value="attachedTransferDeviceLabels")
        private List<String> attachedTransferDeviceLabels;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder transferJobId(String transferJobId) {
            this.transferJobId = transferJobId;
            this.__explicitlySet__.add("transferJobId");
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            this.__explicitlySet__.add("creationTime");
            return this;
        }

        public Builder originalPackageDeliveryTrackingNumber(String originalPackageDeliveryTrackingNumber) {
            this.originalPackageDeliveryTrackingNumber = originalPackageDeliveryTrackingNumber;
            this.__explicitlySet__.add("originalPackageDeliveryTrackingNumber");
            return this;
        }

        public Builder returnPackageDeliveryTrackingNumber(String returnPackageDeliveryTrackingNumber) {
            this.returnPackageDeliveryTrackingNumber = returnPackageDeliveryTrackingNumber;
            this.__explicitlySet__.add("returnPackageDeliveryTrackingNumber");
            return this;
        }

        public Builder packageDeliveryVendor(String packageDeliveryVendor) {
            this.packageDeliveryVendor = packageDeliveryVendor;
            this.__explicitlySet__.add("packageDeliveryVendor");
            return this;
        }

        public Builder transferSiteShippingAddress(String transferSiteShippingAddress) {
            this.transferSiteShippingAddress = transferSiteShippingAddress;
            this.__explicitlySet__.add("transferSiteShippingAddress");
            return this;
        }

        public Builder attachedTransferDeviceLabels(List<String> attachedTransferDeviceLabels) {
            this.attachedTransferDeviceLabels = attachedTransferDeviceLabels;
            this.__explicitlySet__.add("attachedTransferDeviceLabels");
            return this;
        }

        public TransferPackage build() {
            TransferPackage model = new TransferPackage(this.label, this.lifecycleState, this.transferJobId, this.creationTime, this.originalPackageDeliveryTrackingNumber, this.returnPackageDeliveryTrackingNumber, this.packageDeliveryVendor, this.transferSiteShippingAddress, this.attachedTransferDeviceLabels);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TransferPackage model) {
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("transferJobId")) {
                this.transferJobId(model.getTransferJobId());
            }
            if (model.wasPropertyExplicitlySet("creationTime")) {
                this.creationTime(model.getCreationTime());
            }
            if (model.wasPropertyExplicitlySet("originalPackageDeliveryTrackingNumber")) {
                this.originalPackageDeliveryTrackingNumber(model.getOriginalPackageDeliveryTrackingNumber());
            }
            if (model.wasPropertyExplicitlySet("returnPackageDeliveryTrackingNumber")) {
                this.returnPackageDeliveryTrackingNumber(model.getReturnPackageDeliveryTrackingNumber());
            }
            if (model.wasPropertyExplicitlySet("packageDeliveryVendor")) {
                this.packageDeliveryVendor(model.getPackageDeliveryVendor());
            }
            if (model.wasPropertyExplicitlySet("transferSiteShippingAddress")) {
                this.transferSiteShippingAddress(model.getTransferSiteShippingAddress());
            }
            if (model.wasPropertyExplicitlySet("attachedTransferDeviceLabels")) {
                this.attachedTransferDeviceLabels(model.getAttachedTransferDeviceLabels());
            }
            return this;
        }
    }
}

