/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.CreateTransferApplianceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTransferApplianceRequest
extends BmcRequest<CreateTransferApplianceDetails> {
    private String id;
    private String opcRetryToken;
    private CreateTransferApplianceDetails createTransferApplianceDetails;

    public String getId() {
        return this.id;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public CreateTransferApplianceDetails getCreateTransferApplianceDetails() {
        return this.createTransferApplianceDetails;
    }

    @InternalSdk
    public CreateTransferApplianceDetails getBody$() {
        return this.createTransferApplianceDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).opcRetryToken(this.opcRetryToken).createTransferApplianceDetails(this.createTransferApplianceDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",createTransferApplianceDetails=").append(String.valueOf((Object)this.createTransferApplianceDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTransferApplianceRequest)) {
            return false;
        }
        CreateTransferApplianceRequest other = (CreateTransferApplianceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.createTransferApplianceDetails, (Object)other.createTransferApplianceDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.createTransferApplianceDetails == null ? 43 : this.createTransferApplianceDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTransferApplianceRequest, CreateTransferApplianceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String opcRetryToken = null;
        private CreateTransferApplianceDetails createTransferApplianceDetails = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder createTransferApplianceDetails(CreateTransferApplianceDetails createTransferApplianceDetails) {
            this.createTransferApplianceDetails = createTransferApplianceDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferApplianceRequest o) {
            this.id(o.getId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.createTransferApplianceDetails(o.getCreateTransferApplianceDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferApplianceRequest build() {
            CreateTransferApplianceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTransferApplianceDetails body) {
            this.createTransferApplianceDetails(body);
            return this;
        }

        public CreateTransferApplianceRequest buildWithoutInvocationCallback() {
            CreateTransferApplianceRequest request = new CreateTransferApplianceRequest();
            request.id = this.id;
            request.opcRetryToken = this.opcRetryToken;
            request.createTransferApplianceDetails = this.createTransferApplianceDetails;
            return request;
        }
    }
}

