/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.CreateTransferPackageDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTransferPackageRequest
extends BmcRequest<CreateTransferPackageDetails> {
    private String id;
    private String opcRetryToken;
    private CreateTransferPackageDetails createTransferPackageDetails;

    public String getId() {
        return this.id;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public CreateTransferPackageDetails getCreateTransferPackageDetails() {
        return this.createTransferPackageDetails;
    }

    @InternalSdk
    public CreateTransferPackageDetails getBody$() {
        return this.createTransferPackageDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).opcRetryToken(this.opcRetryToken).createTransferPackageDetails(this.createTransferPackageDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",createTransferPackageDetails=").append(String.valueOf((Object)this.createTransferPackageDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTransferPackageRequest)) {
            return false;
        }
        CreateTransferPackageRequest other = (CreateTransferPackageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.createTransferPackageDetails, (Object)other.createTransferPackageDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.createTransferPackageDetails == null ? 43 : this.createTransferPackageDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTransferPackageRequest, CreateTransferPackageDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String opcRetryToken = null;
        private CreateTransferPackageDetails createTransferPackageDetails = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder createTransferPackageDetails(CreateTransferPackageDetails createTransferPackageDetails) {
            this.createTransferPackageDetails = createTransferPackageDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferPackageRequest o) {
            this.id(o.getId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.createTransferPackageDetails(o.getCreateTransferPackageDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferPackageRequest build() {
            CreateTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTransferPackageDetails body) {
            this.createTransferPackageDetails(body);
            return this;
        }

        public CreateTransferPackageRequest buildWithoutInvocationCallback() {
            CreateTransferPackageRequest request = new CreateTransferPackageRequest();
            request.id = this.id;
            request.opcRetryToken = this.opcRetryToken;
            request.createTransferPackageDetails = this.createTransferPackageDetails;
            return request;
        }
    }
}

