/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.email.Email;
import com.oracle.bmc.email.model.SenderSummary;
import com.oracle.bmc.email.model.SuppressionSummary;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class EmailPaginators {
    private final Email client;

    public Iterable<ListSendersResponse> listSendersResponseIterator(final ListSendersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSendersRequest.Builder>(){

            public ListSendersRequest.Builder get() {
                return ListSendersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSendersResponse, String>(){

            public String apply(ListSendersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSendersRequest.Builder>, ListSendersRequest>(){

            public ListSendersRequest apply(RequestBuilderAndToken<ListSendersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSendersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSendersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSendersRequest, ListSendersResponse>(){

            public ListSendersResponse apply(ListSendersRequest request) {
                return EmailPaginators.this.client.listSenders(request);
            }
        });
    }

    public Iterable<SenderSummary> listSendersRecordIterator(final ListSendersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSendersRequest.Builder>(){

            public ListSendersRequest.Builder get() {
                return ListSendersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSendersResponse, String>(){

            public String apply(ListSendersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSendersRequest.Builder>, ListSendersRequest>(){

            public ListSendersRequest apply(RequestBuilderAndToken<ListSendersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSendersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSendersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSendersRequest, ListSendersResponse>(){

            public ListSendersResponse apply(ListSendersRequest request) {
                return EmailPaginators.this.client.listSenders(request);
            }
        }, (Function)new Function<ListSendersResponse, List<SenderSummary>>(){

            public List<SenderSummary> apply(ListSendersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSuppressionsResponse> listSuppressionsResponseIterator(final ListSuppressionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSuppressionsRequest.Builder>(){

            public ListSuppressionsRequest.Builder get() {
                return ListSuppressionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSuppressionsResponse, String>(){

            public String apply(ListSuppressionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSuppressionsRequest.Builder>, ListSuppressionsRequest>(){

            public ListSuppressionsRequest apply(RequestBuilderAndToken<ListSuppressionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSuppressionsRequest, ListSuppressionsResponse>(){

            public ListSuppressionsResponse apply(ListSuppressionsRequest request) {
                return EmailPaginators.this.client.listSuppressions(request);
            }
        });
    }

    public Iterable<SuppressionSummary> listSuppressionsRecordIterator(final ListSuppressionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSuppressionsRequest.Builder>(){

            public ListSuppressionsRequest.Builder get() {
                return ListSuppressionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSuppressionsResponse, String>(){

            public String apply(ListSuppressionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSuppressionsRequest.Builder>, ListSuppressionsRequest>(){

            public ListSuppressionsRequest apply(RequestBuilderAndToken<ListSuppressionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSuppressionsRequest, ListSuppressionsResponse>(){

            public ListSuppressionsResponse apply(ListSuppressionsRequest request) {
                return EmailPaginators.this.client.listSuppressions(request);
            }
        }, (Function)new Function<ListSuppressionsResponse, List<SuppressionSummary>>(){

            public List<SuppressionSummary> apply(ListSuppressionsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public EmailPaginators(Email client) {
        this.client = client;
    }
}

