/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.email.Email;
import com.oracle.bmc.email.model.Sender;
import com.oracle.bmc.email.requests.GetSenderRequest;
import com.oracle.bmc.email.responses.GetSenderResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class EmailWaiters {
    private final ExecutorService executorService;
    private final Email client;

    public Waiter<GetSenderRequest, GetSenderResponse> forSender(GetSenderRequest request, Sender.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSender(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSenderRequest, GetSenderResponse> forSender(GetSenderRequest request, Sender.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSender(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSenderRequest, GetSenderResponse> forSender(GetSenderRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Sender.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSender(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSenderRequest, GetSenderResponse> forSender(BmcGenericWaiter waiter, GetSenderRequest request, Sender.LifecycleState ... targetStates) {
        final HashSet<Sender.LifecycleState> targetStatesSet = new HashSet<Sender.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetSenderRequest, GetSenderResponse>(){

            public GetSenderResponse apply(GetSenderRequest request) {
                return EmailWaiters.this.client.getSender(request);
            }
        }, (Predicate)new Predicate<GetSenderResponse>(){

            public boolean apply(GetSenderResponse response) {
                return targetStatesSet.contains((Object)response.getSender().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Sender.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public EmailWaiters(ExecutorService executorService, Email client) {
        this.executorService = executorService;
        this.client = client;
    }
}

