/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email;

import com.oracle.bmc.email.Email;
import com.oracle.bmc.email.model.DkimSummary;
import com.oracle.bmc.email.model.EmailDomainSummary;
import com.oracle.bmc.email.model.SenderSummary;
import com.oracle.bmc.email.model.SuppressionSummary;
import com.oracle.bmc.email.model.WorkRequestError;
import com.oracle.bmc.email.model.WorkRequestLogEntry;
import com.oracle.bmc.email.model.WorkRequestSummary;
import com.oracle.bmc.email.requests.ListDkimsRequest;
import com.oracle.bmc.email.requests.ListEmailDomainsRequest;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestsRequest;
import com.oracle.bmc.email.responses.ListDkimsResponse;
import com.oracle.bmc.email.responses.ListEmailDomainsResponse;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class EmailPaginators {
    private final Email client;

    public EmailPaginators(Email client) {
        this.client = client;
    }

    public Iterable<ListDkimsResponse> listDkimsResponseIterator(final ListDkimsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDkimsRequest.Builder>(){

            @Override
            public ListDkimsRequest.Builder get() {
                return ListDkimsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDkimsResponse, String>(){

            @Override
            public String apply(ListDkimsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDkimsRequest.Builder>, ListDkimsRequest>(){

            @Override
            public ListDkimsRequest apply(RequestBuilderAndToken<ListDkimsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDkimsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDkimsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDkimsRequest, ListDkimsResponse>(){

            @Override
            public ListDkimsResponse apply(ListDkimsRequest request) {
                return EmailPaginators.this.client.listDkims(request);
            }
        });
    }

    public Iterable<DkimSummary> listDkimsRecordIterator(final ListDkimsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDkimsRequest.Builder>(){

            @Override
            public ListDkimsRequest.Builder get() {
                return ListDkimsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDkimsResponse, String>(){

            @Override
            public String apply(ListDkimsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDkimsRequest.Builder>, ListDkimsRequest>(){

            @Override
            public ListDkimsRequest apply(RequestBuilderAndToken<ListDkimsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDkimsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDkimsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDkimsRequest, ListDkimsResponse>(){

            @Override
            public ListDkimsResponse apply(ListDkimsRequest request) {
                return EmailPaginators.this.client.listDkims(request);
            }
        }, (Function)new Function<ListDkimsResponse, List<DkimSummary>>(){

            @Override
            public List<DkimSummary> apply(ListDkimsResponse response) {
                return response.getDkimCollection().getItems();
            }
        });
    }

    public Iterable<ListEmailDomainsResponse> listEmailDomainsResponseIterator(final ListEmailDomainsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEmailDomainsRequest.Builder>(){

            @Override
            public ListEmailDomainsRequest.Builder get() {
                return ListEmailDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEmailDomainsResponse, String>(){

            @Override
            public String apply(ListEmailDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEmailDomainsRequest.Builder>, ListEmailDomainsRequest>(){

            @Override
            public ListEmailDomainsRequest apply(RequestBuilderAndToken<ListEmailDomainsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEmailDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEmailDomainsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEmailDomainsRequest, ListEmailDomainsResponse>(){

            @Override
            public ListEmailDomainsResponse apply(ListEmailDomainsRequest request) {
                return EmailPaginators.this.client.listEmailDomains(request);
            }
        });
    }

    public Iterable<EmailDomainSummary> listEmailDomainsRecordIterator(final ListEmailDomainsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEmailDomainsRequest.Builder>(){

            @Override
            public ListEmailDomainsRequest.Builder get() {
                return ListEmailDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEmailDomainsResponse, String>(){

            @Override
            public String apply(ListEmailDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEmailDomainsRequest.Builder>, ListEmailDomainsRequest>(){

            @Override
            public ListEmailDomainsRequest apply(RequestBuilderAndToken<ListEmailDomainsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEmailDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEmailDomainsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEmailDomainsRequest, ListEmailDomainsResponse>(){

            @Override
            public ListEmailDomainsResponse apply(ListEmailDomainsRequest request) {
                return EmailPaginators.this.client.listEmailDomains(request);
            }
        }, (Function)new Function<ListEmailDomainsResponse, List<EmailDomainSummary>>(){

            @Override
            public List<EmailDomainSummary> apply(ListEmailDomainsResponse response) {
                return response.getEmailDomainCollection().getItems();
            }
        });
    }

    public Iterable<ListSendersResponse> listSendersResponseIterator(final ListSendersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSendersRequest.Builder>(){

            @Override
            public ListSendersRequest.Builder get() {
                return ListSendersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSendersResponse, String>(){

            @Override
            public String apply(ListSendersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSendersRequest.Builder>, ListSendersRequest>(){

            @Override
            public ListSendersRequest apply(RequestBuilderAndToken<ListSendersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSendersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSendersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSendersRequest, ListSendersResponse>(){

            @Override
            public ListSendersResponse apply(ListSendersRequest request) {
                return EmailPaginators.this.client.listSenders(request);
            }
        });
    }

    public Iterable<SenderSummary> listSendersRecordIterator(final ListSendersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSendersRequest.Builder>(){

            @Override
            public ListSendersRequest.Builder get() {
                return ListSendersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSendersResponse, String>(){

            @Override
            public String apply(ListSendersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSendersRequest.Builder>, ListSendersRequest>(){

            @Override
            public ListSendersRequest apply(RequestBuilderAndToken<ListSendersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSendersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSendersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSendersRequest, ListSendersResponse>(){

            @Override
            public ListSendersResponse apply(ListSendersRequest request) {
                return EmailPaginators.this.client.listSenders(request);
            }
        }, (Function)new Function<ListSendersResponse, List<SenderSummary>>(){

            @Override
            public List<SenderSummary> apply(ListSendersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSuppressionsResponse> listSuppressionsResponseIterator(final ListSuppressionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSuppressionsRequest.Builder>(){

            @Override
            public ListSuppressionsRequest.Builder get() {
                return ListSuppressionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSuppressionsResponse, String>(){

            @Override
            public String apply(ListSuppressionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSuppressionsRequest.Builder>, ListSuppressionsRequest>(){

            @Override
            public ListSuppressionsRequest apply(RequestBuilderAndToken<ListSuppressionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSuppressionsRequest, ListSuppressionsResponse>(){

            @Override
            public ListSuppressionsResponse apply(ListSuppressionsRequest request) {
                return EmailPaginators.this.client.listSuppressions(request);
            }
        });
    }

    public Iterable<SuppressionSummary> listSuppressionsRecordIterator(final ListSuppressionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSuppressionsRequest.Builder>(){

            @Override
            public ListSuppressionsRequest.Builder get() {
                return ListSuppressionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSuppressionsResponse, String>(){

            @Override
            public String apply(ListSuppressionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSuppressionsRequest.Builder>, ListSuppressionsRequest>(){

            @Override
            public ListSuppressionsRequest apply(RequestBuilderAndToken<ListSuppressionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSuppressionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSuppressionsRequest, ListSuppressionsResponse>(){

            @Override
            public ListSuppressionsResponse apply(ListSuppressionsRequest request) {
                return EmailPaginators.this.client.listSuppressions(request);
            }
        }, (Function)new Function<ListSuppressionsResponse, List<SuppressionSummary>>(){

            @Override
            public List<SuppressionSummary> apply(ListSuppressionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return EmailPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return EmailPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return EmailPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return EmailPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return EmailPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return EmailPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

