/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.email.model.Dkim;
import com.oracle.bmc.email.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDkimsRequest
extends BmcRequest<Void> {
    private String emailDomainId;
    private String opcRequestId;
    private String id;
    private String name;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private Dkim.LifecycleState lifecycleState;
    private SortBy sortBy;

    public String getEmailDomainId() {
        return this.emailDomainId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Dkim.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().emailDomainId(this.emailDomainId).opcRequestId(this.opcRequestId).id(this.id).name(this.name).limit(this.limit).page(this.page).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",emailDomainId=").append(String.valueOf(this.emailDomainId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDkimsRequest)) {
            return false;
        }
        ListDkimsRequest other = (ListDkimsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.emailDomainId, other.emailDomainId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.emailDomainId == null ? 43 : this.emailDomainId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDkimsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String emailDomainId = null;
        private String opcRequestId = null;
        private String id = null;
        private String name = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private Dkim.LifecycleState lifecycleState = null;
        private SortBy sortBy = null;

        public Builder emailDomainId(String emailDomainId) {
            this.emailDomainId = emailDomainId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(Dkim.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDkimsRequest o) {
            this.emailDomainId(o.getEmailDomainId());
            this.opcRequestId(o.getOpcRequestId());
            this.id(o.getId());
            this.name(o.getName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDkimsRequest build() {
            ListDkimsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDkimsRequest buildWithoutInvocationCallback() {
            ListDkimsRequest request = new ListDkimsRequest();
            request.emailDomainId = this.emailDomainId;
            request.opcRequestId = this.opcRequestId;
            request.id = this.id;
            request.name = this.name;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Id("ID"),
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

