/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.email.EmailAsync;
import com.oracle.bmc.email.model.Dkim;
import com.oracle.bmc.email.model.DkimCollection;
import com.oracle.bmc.email.model.EmailDomain;
import com.oracle.bmc.email.model.EmailDomainCollection;
import com.oracle.bmc.email.model.Sender;
import com.oracle.bmc.email.model.SenderSummary;
import com.oracle.bmc.email.model.Suppression;
import com.oracle.bmc.email.model.SuppressionSummary;
import com.oracle.bmc.email.model.WorkRequest;
import com.oracle.bmc.email.model.WorkRequestErrorCollection;
import com.oracle.bmc.email.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.email.model.WorkRequestSummaryCollection;
import com.oracle.bmc.email.requests.ChangeEmailDomainCompartmentRequest;
import com.oracle.bmc.email.requests.ChangeSenderCompartmentRequest;
import com.oracle.bmc.email.requests.CreateDkimRequest;
import com.oracle.bmc.email.requests.CreateEmailDomainRequest;
import com.oracle.bmc.email.requests.CreateSenderRequest;
import com.oracle.bmc.email.requests.CreateSuppressionRequest;
import com.oracle.bmc.email.requests.DeleteDkimRequest;
import com.oracle.bmc.email.requests.DeleteEmailDomainRequest;
import com.oracle.bmc.email.requests.DeleteSenderRequest;
import com.oracle.bmc.email.requests.DeleteSuppressionRequest;
import com.oracle.bmc.email.requests.GetDkimRequest;
import com.oracle.bmc.email.requests.GetEmailDomainRequest;
import com.oracle.bmc.email.requests.GetSenderRequest;
import com.oracle.bmc.email.requests.GetSuppressionRequest;
import com.oracle.bmc.email.requests.GetWorkRequestRequest;
import com.oracle.bmc.email.requests.ListDkimsRequest;
import com.oracle.bmc.email.requests.ListEmailDomainsRequest;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestsRequest;
import com.oracle.bmc.email.requests.UpdateDkimRequest;
import com.oracle.bmc.email.requests.UpdateEmailDomainRequest;
import com.oracle.bmc.email.requests.UpdateSenderRequest;
import com.oracle.bmc.email.responses.ChangeEmailDomainCompartmentResponse;
import com.oracle.bmc.email.responses.ChangeSenderCompartmentResponse;
import com.oracle.bmc.email.responses.CreateDkimResponse;
import com.oracle.bmc.email.responses.CreateEmailDomainResponse;
import com.oracle.bmc.email.responses.CreateSenderResponse;
import com.oracle.bmc.email.responses.CreateSuppressionResponse;
import com.oracle.bmc.email.responses.DeleteDkimResponse;
import com.oracle.bmc.email.responses.DeleteEmailDomainResponse;
import com.oracle.bmc.email.responses.DeleteSenderResponse;
import com.oracle.bmc.email.responses.DeleteSuppressionResponse;
import com.oracle.bmc.email.responses.GetDkimResponse;
import com.oracle.bmc.email.responses.GetEmailDomainResponse;
import com.oracle.bmc.email.responses.GetSenderResponse;
import com.oracle.bmc.email.responses.GetSuppressionResponse;
import com.oracle.bmc.email.responses.GetWorkRequestResponse;
import com.oracle.bmc.email.responses.ListDkimsResponse;
import com.oracle.bmc.email.responses.ListEmailDomainsResponse;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestsResponse;
import com.oracle.bmc.email.responses.UpdateDkimResponse;
import com.oracle.bmc.email.responses.UpdateEmailDomainResponse;
import com.oracle.bmc.email.responses.UpdateSenderResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAsyncClient
extends BaseAsyncClient
implements EmailAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EMAIL").serviceEndpointPrefix("email").serviceEndpointTemplate("https://ctrl.email.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EmailAsyncClient.class);

    EmailAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeEmailDomainCompartmentResponse> changeEmailDomainCompartment(ChangeEmailDomainCompartmentRequest request, AsyncHandler<ChangeEmailDomainCompartmentRequest, ChangeEmailDomainCompartmentResponse> handler) {
        Validate.notBlank((String)request.getEmailDomainId(), (String)"emailDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeEmailDomainCompartmentDetails(), "changeEmailDomainCompartmentDetails is required");
        return this.clientCall(request, ChangeEmailDomainCompartmentResponse::builder).logger(LOG, "changeEmailDomainCompartment").serviceDetails("Email", "ChangeEmailDomainCompartment", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/EmailDomain/ChangeEmailDomainCompartment").method(Method.POST).requestBuilder(ChangeEmailDomainCompartmentRequest::builder).basePath("/20170907").appendPathParam("emailDomains").appendPathParam(request.getEmailDomainId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeEmailDomainCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeEmailDomainCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeSenderCompartmentResponse> changeSenderCompartment(ChangeSenderCompartmentRequest request, AsyncHandler<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse> handler) {
        Validate.notBlank((String)request.getSenderId(), (String)"senderId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSenderCompartmentDetails(), "changeSenderCompartmentDetails is required");
        return this.clientCall(request, ChangeSenderCompartmentResponse::builder).logger(LOG, "changeSenderCompartment").serviceDetails("Email", "ChangeSenderCompartment", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Sender/ChangeSenderCompartment").method(Method.POST).requestBuilder(ChangeSenderCompartmentRequest::builder).basePath("/20170907").appendPathParam("senders").appendPathParam(request.getSenderId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSenderCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDkimResponse> createDkim(CreateDkimRequest request, AsyncHandler<CreateDkimRequest, CreateDkimResponse> handler) {
        Objects.requireNonNull(request.getCreateDkimDetails(), "createDkimDetails is required");
        return this.clientCall(request, CreateDkimResponse::builder).logger(LOG, "createDkim").serviceDetails("Email", "CreateDkim", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Dkim/CreateDkim").method(Method.POST).requestBuilder(CreateDkimRequest::builder).basePath("/20170907").appendPathParam("dkims").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Dkim.class, CreateDkimResponse.Builder::dkim).handleResponseHeaderString("Content-Location", CreateDkimResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateDkimResponse.Builder::etag).handleResponseHeaderString("Location", CreateDkimResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateDkimResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDkimResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEmailDomainResponse> createEmailDomain(CreateEmailDomainRequest request, AsyncHandler<CreateEmailDomainRequest, CreateEmailDomainResponse> handler) {
        Objects.requireNonNull(request.getCreateEmailDomainDetails(), "createEmailDomainDetails is required");
        return this.clientCall(request, CreateEmailDomainResponse::builder).logger(LOG, "createEmailDomain").serviceDetails("Email", "CreateEmailDomain", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/EmailDomain/CreateEmailDomain").method(Method.POST).requestBuilder(CreateEmailDomainRequest::builder).basePath("/20170907").appendPathParam("emailDomains").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(EmailDomain.class, CreateEmailDomainResponse.Builder::emailDomain).handleResponseHeaderString("Content-Location", CreateEmailDomainResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateEmailDomainResponse.Builder::etag).handleResponseHeaderString("Location", CreateEmailDomainResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateEmailDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateEmailDomainResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSenderResponse> createSender(CreateSenderRequest request, AsyncHandler<CreateSenderRequest, CreateSenderResponse> handler) {
        Objects.requireNonNull(request.getCreateSenderDetails(), "createSenderDetails is required");
        return this.clientCall(request, CreateSenderResponse::builder).logger(LOG, "createSender").serviceDetails("Email", "CreateSender", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Sender/CreateSender").method(Method.POST).requestBuilder(CreateSenderRequest::builder).basePath("/20170907").appendPathParam("senders").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Sender.class, CreateSenderResponse.Builder::sender).handleResponseHeaderString("opc-request-id", CreateSenderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSenderResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateSuppressionResponse> createSuppression(CreateSuppressionRequest request, AsyncHandler<CreateSuppressionRequest, CreateSuppressionResponse> handler) {
        Objects.requireNonNull(request.getCreateSuppressionDetails(), "createSuppressionDetails is required");
        return this.clientCall(request, CreateSuppressionResponse::builder).logger(LOG, "createSuppression").serviceDetails("Email", "CreateSuppression", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Suppression/CreateSuppression").method(Method.POST).requestBuilder(CreateSuppressionRequest::builder).basePath("/20170907").appendPathParam("suppressions").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Suppression.class, CreateSuppressionResponse.Builder::suppression).handleResponseHeaderString("opc-request-id", CreateSuppressionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDkimResponse> deleteDkim(DeleteDkimRequest request, AsyncHandler<DeleteDkimRequest, DeleteDkimResponse> handler) {
        Validate.notBlank((String)request.getDkimId(), (String)"dkimId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDkimResponse::builder).logger(LOG, "deleteDkim").serviceDetails("Email", "DeleteDkim", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Dkim/DeleteDkim").method(Method.DELETE).requestBuilder(DeleteDkimRequest::builder).basePath("/20170907").appendPathParam("dkims").appendPathParam(request.getDkimId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDkimResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDkimResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteEmailDomainResponse> deleteEmailDomain(DeleteEmailDomainRequest request, AsyncHandler<DeleteEmailDomainRequest, DeleteEmailDomainResponse> handler) {
        Validate.notBlank((String)request.getEmailDomainId(), (String)"emailDomainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteEmailDomainResponse::builder).logger(LOG, "deleteEmailDomain").serviceDetails("Email", "DeleteEmailDomain", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/EmailDomain/DeleteEmailDomain").method(Method.DELETE).requestBuilder(DeleteEmailDomainRequest::builder).basePath("/20170907").appendPathParam("emailDomains").appendPathParam(request.getEmailDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteEmailDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEmailDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSenderResponse> deleteSender(DeleteSenderRequest request, AsyncHandler<DeleteSenderRequest, DeleteSenderResponse> handler) {
        Validate.notBlank((String)request.getSenderId(), (String)"senderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSenderResponse::builder).logger(LOG, "deleteSender").serviceDetails("Email", "DeleteSender", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Sender/DeleteSender").method(Method.DELETE).requestBuilder(DeleteSenderRequest::builder).basePath("/20170907").appendPathParam("senders").appendPathParam(request.getSenderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSenderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSuppressionResponse> deleteSuppression(DeleteSuppressionRequest request, AsyncHandler<DeleteSuppressionRequest, DeleteSuppressionResponse> handler) {
        Validate.notBlank((String)request.getSuppressionId(), (String)"suppressionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSuppressionResponse::builder).logger(LOG, "deleteSuppression").serviceDetails("Email", "DeleteSuppression", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Suppression/DeleteSuppression").method(Method.DELETE).requestBuilder(DeleteSuppressionRequest::builder).basePath("/20170907").appendPathParam("suppressions").appendPathParam(request.getSuppressionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSuppressionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDkimResponse> getDkim(GetDkimRequest request, AsyncHandler<GetDkimRequest, GetDkimResponse> handler) {
        Validate.notBlank((String)request.getDkimId(), (String)"dkimId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDkimResponse::builder).logger(LOG, "getDkim").serviceDetails("Email", "GetDkim", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Dkim/GetDkim").method(Method.GET).requestBuilder(GetDkimRequest::builder).basePath("/20170907").appendPathParam("dkims").appendPathParam(request.getDkimId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Dkim.class, GetDkimResponse.Builder::dkim).handleResponseHeaderString("etag", GetDkimResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDkimResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEmailDomainResponse> getEmailDomain(GetEmailDomainRequest request, AsyncHandler<GetEmailDomainRequest, GetEmailDomainResponse> handler) {
        Validate.notBlank((String)request.getEmailDomainId(), (String)"emailDomainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEmailDomainResponse::builder).logger(LOG, "getEmailDomain").serviceDetails("Email", "GetEmailDomain", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/EmailDomain/GetEmailDomain").method(Method.GET).requestBuilder(GetEmailDomainRequest::builder).basePath("/20170907").appendPathParam("emailDomains").appendPathParam(request.getEmailDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EmailDomain.class, GetEmailDomainResponse.Builder::emailDomain).handleResponseHeaderString("etag", GetEmailDomainResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEmailDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSenderResponse> getSender(GetSenderRequest request, AsyncHandler<GetSenderRequest, GetSenderResponse> handler) {
        Validate.notBlank((String)request.getSenderId(), (String)"senderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSenderResponse::builder).logger(LOG, "getSender").serviceDetails("Email", "GetSender", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Sender/GetSender").method(Method.GET).requestBuilder(GetSenderRequest::builder).basePath("/20170907").appendPathParam("senders").appendPathParam(request.getSenderId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Sender.class, GetSenderResponse.Builder::sender).handleResponseHeaderString("opc-request-id", GetSenderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSenderResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetSuppressionResponse> getSuppression(GetSuppressionRequest request, AsyncHandler<GetSuppressionRequest, GetSuppressionResponse> handler) {
        Validate.notBlank((String)request.getSuppressionId(), (String)"suppressionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSuppressionResponse::builder).logger(LOG, "getSuppression").serviceDetails("Email", "GetSuppression", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Suppression/GetSuppression").method(Method.GET).requestBuilder(GetSuppressionRequest::builder).basePath("/20170907").appendPathParam("suppressions").appendPathParam(request.getSuppressionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Suppression.class, GetSuppressionResponse.Builder::suppression).handleResponseHeaderString("opc-request-id", GetSuppressionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Email", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20170907").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListDkimsResponse> listDkims(ListDkimsRequest request, AsyncHandler<ListDkimsRequest, ListDkimsResponse> handler) {
        Objects.requireNonNull(request.getEmailDomainId(), "emailDomainId is required");
        return this.clientCall(request, ListDkimsResponse::builder).logger(LOG, "listDkims").serviceDetails("Email", "ListDkims", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Dkim/ListDkims").method(Method.GET).requestBuilder(ListDkimsRequest::builder).basePath("/20170907").appendPathParam("dkims").appendQueryParam("emailDomainId", (Object)request.getEmailDomainId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DkimCollection.class, ListDkimsResponse.Builder::dkimCollection).handleResponseHeaderString("opc-next-page", ListDkimsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDkimsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListEmailDomainsResponse> listEmailDomains(ListEmailDomainsRequest request, AsyncHandler<ListEmailDomainsRequest, ListEmailDomainsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEmailDomainsResponse::builder).logger(LOG, "listEmailDomains").serviceDetails("Email", "ListEmailDomains", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/EmailDomain/ListEmailDomains").method(Method.GET).requestBuilder(ListEmailDomainsRequest::builder).basePath("/20170907").appendPathParam("emailDomains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EmailDomainCollection.class, ListEmailDomainsResponse.Builder::emailDomainCollection).handleResponseHeaderString("opc-next-page", ListEmailDomainsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListEmailDomainsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSendersResponse> listSenders(ListSendersRequest request, AsyncHandler<ListSendersRequest, ListSendersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSendersResponse::builder).logger(LOG, "listSenders").serviceDetails("Email", "ListSenders", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Sender/ListSenders").method(Method.GET).requestBuilder(ListSendersRequest::builder).basePath("/20170907").appendPathParam("senders").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("domain", (Object)request.getDomain()).appendQueryParam("emailAddress", (Object)request.getEmailAddress()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SenderSummary.class, ListSendersResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSendersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSendersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSendersResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListSendersResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListSuppressionsResponse> listSuppressions(ListSuppressionsRequest request, AsyncHandler<ListSuppressionsRequest, ListSuppressionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSuppressionsResponse::builder).logger(LOG, "listSuppressions").serviceDetails("Email", "ListSuppressions", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Suppression/ListSuppressions").method(Method.GET).requestBuilder(ListSuppressionsRequest::builder).basePath("/20170907").appendPathParam("suppressions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("emailAddress", (Object)request.getEmailAddress()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SuppressionSummary.class, ListSuppressionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSuppressionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSuppressionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSuppressionsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Email", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20170907").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Email", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20170907").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Email", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20170907").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateDkimResponse> updateDkim(UpdateDkimRequest request, AsyncHandler<UpdateDkimRequest, UpdateDkimResponse> handler) {
        Validate.notBlank((String)request.getDkimId(), (String)"dkimId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDkimDetails(), "updateDkimDetails is required");
        return this.clientCall(request, UpdateDkimResponse::builder).logger(LOG, "updateDkim").serviceDetails("Email", "UpdateDkim", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Dkim/UpdateDkim").method(Method.PUT).requestBuilder(UpdateDkimRequest::builder).basePath("/20170907").appendPathParam("dkims").appendPathParam(request.getDkimId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDkimResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDkimResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateEmailDomainResponse> updateEmailDomain(UpdateEmailDomainRequest request, AsyncHandler<UpdateEmailDomainRequest, UpdateEmailDomainResponse> handler) {
        Validate.notBlank((String)request.getEmailDomainId(), (String)"emailDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEmailDomainDetails(), "updateEmailDomainDetails is required");
        return this.clientCall(request, UpdateEmailDomainResponse::builder).logger(LOG, "updateEmailDomain").serviceDetails("Email", "UpdateEmailDomain", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/EmailDomain/UpdateEmailDomain").method(Method.PUT).requestBuilder(UpdateEmailDomainRequest::builder).basePath("/20170907").appendPathParam("emailDomains").appendPathParam(request.getEmailDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateEmailDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateEmailDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSenderResponse> updateSender(UpdateSenderRequest request, AsyncHandler<UpdateSenderRequest, UpdateSenderResponse> handler) {
        Validate.notBlank((String)request.getSenderId(), (String)"senderId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSenderDetails(), "updateSenderDetails is required");
        return this.clientCall(request, UpdateSenderResponse::builder).logger(LOG, "updateSender").serviceDetails("Email", "UpdateSender", "https://docs.oracle.com/iaas/api/#/en/emaildelivery/20170907/Sender/UpdateSender").method(Method.PUT).requestBuilder(UpdateSenderRequest::builder).basePath("/20170907").appendPathParam("senders").appendPathParam(request.getSenderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Sender.class, UpdateSenderResponse.Builder::sender).handleResponseHeaderString("opc-request-id", UpdateSenderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateSenderResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EmailAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EmailAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EmailAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EmailAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EmailAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EmailAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EmailAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EmailAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "email";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"email");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public EmailAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EmailAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

