/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.responses;

import com.oracle.bmc.email.model.EmailDomain;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateEmailDomainResponse
extends BmcResponse {
    private String contentLocation;
    private String etag;
    private String location;
    private String opcRequestId;
    private String opcWorkRequestId;
    private EmailDomain emailDomain;

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public EmailDomain getEmailDomain() {
        return this.emailDomain;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "contentLocation", "etag", "location", "opcRequestId", "opcWorkRequestId", "emailDomain"})
    private CreateEmailDomainResponse(int __httpStatusCode__, Map<String, List<String>> headers, String contentLocation, String etag, String location, String opcRequestId, String opcWorkRequestId, EmailDomain emailDomain) {
        super(__httpStatusCode__, headers);
        this.contentLocation = contentLocation;
        this.etag = etag;
        this.location = location;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.emailDomain = emailDomain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",contentLocation=").append(String.valueOf(this.contentLocation));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",emailDomain=").append(String.valueOf((Object)this.emailDomain));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateEmailDomainResponse)) {
            return false;
        }
        CreateEmailDomainResponse other = (CreateEmailDomainResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.contentLocation, other.contentLocation) && Objects.equals(this.etag, other.etag) && Objects.equals(this.location, other.location) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals((Object)this.emailDomain, (Object)other.emailDomain);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentLocation == null ? 43 : this.contentLocation.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.emailDomain == null ? 43 : this.emailDomain.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateEmailDomainResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String contentLocation;
        private String etag;
        private String location;
        private String opcRequestId;
        private String opcWorkRequestId;
        private EmailDomain emailDomain;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder emailDomain(EmailDomain emailDomain) {
            this.emailDomain = emailDomain;
            return this;
        }

        public Builder copy(CreateEmailDomainResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.contentLocation(o.getContentLocation());
            this.etag(o.getEtag());
            this.location(o.getLocation());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.emailDomain(o.getEmailDomain());
            return this;
        }

        public CreateEmailDomainResponse build() {
            return new CreateEmailDomainResponse(this.__httpStatusCode__, this.headers, this.contentLocation, this.etag, this.location, this.opcRequestId, this.opcWorkRequestId, this.emailDomain);
        }
    }
}

