/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Configuration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="httpSubmitEndpoint")
    private final String httpSubmitEndpoint;
    @JsonProperty(value="smtpSubmitEndpoint")
    private final String smtpSubmitEndpoint;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "httpSubmitEndpoint", "smtpSubmitEndpoint"})
    public Configuration(String compartmentId, String httpSubmitEndpoint, String smtpSubmitEndpoint) {
        this.compartmentId = compartmentId;
        this.httpSubmitEndpoint = httpSubmitEndpoint;
        this.smtpSubmitEndpoint = smtpSubmitEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getHttpSubmitEndpoint() {
        return this.httpSubmitEndpoint;
    }

    public String getSmtpSubmitEndpoint() {
        return this.smtpSubmitEndpoint;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", httpSubmitEndpoint=").append(String.valueOf(this.httpSubmitEndpoint));
        sb.append(", smtpSubmitEndpoint=").append(String.valueOf(this.smtpSubmitEndpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.httpSubmitEndpoint, other.httpSubmitEndpoint) && Objects.equals(this.smtpSubmitEndpoint, other.smtpSubmitEndpoint) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.httpSubmitEndpoint == null ? 43 : this.httpSubmitEndpoint.hashCode());
        result = result * 59 + (this.smtpSubmitEndpoint == null ? 43 : this.smtpSubmitEndpoint.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="httpSubmitEndpoint")
        private String httpSubmitEndpoint;
        @JsonProperty(value="smtpSubmitEndpoint")
        private String smtpSubmitEndpoint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder httpSubmitEndpoint(String httpSubmitEndpoint) {
            this.httpSubmitEndpoint = httpSubmitEndpoint;
            this.__explicitlySet__.add("httpSubmitEndpoint");
            return this;
        }

        public Builder smtpSubmitEndpoint(String smtpSubmitEndpoint) {
            this.smtpSubmitEndpoint = smtpSubmitEndpoint;
            this.__explicitlySet__.add("smtpSubmitEndpoint");
            return this;
        }

        public Configuration build() {
            Configuration model = new Configuration(this.compartmentId, this.httpSubmitEndpoint, this.smtpSubmitEndpoint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Configuration model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("httpSubmitEndpoint")) {
                this.httpSubmitEndpoint(model.getHttpSubmitEndpoint());
            }
            if (model.wasPropertyExplicitlySet("smtpSubmitEndpoint")) {
                this.smtpSubmitEndpoint(model.getSmtpSubmitEndpoint());
            }
            return this;
        }
    }
}

