/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.email.model.ChangeSenderCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeSenderCompartmentRequest
extends BmcRequest<ChangeSenderCompartmentDetails> {
    private String senderId;
    private ChangeSenderCompartmentDetails changeSenderCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSenderId() {
        return this.senderId;
    }

    public ChangeSenderCompartmentDetails getChangeSenderCompartmentDetails() {
        return this.changeSenderCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeSenderCompartmentDetails getBody$() {
        return this.changeSenderCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().senderId(this.senderId).changeSenderCompartmentDetails(this.changeSenderCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",senderId=").append(String.valueOf(this.senderId));
        sb.append(",changeSenderCompartmentDetails=").append(String.valueOf((Object)this.changeSenderCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeSenderCompartmentRequest)) {
            return false;
        }
        ChangeSenderCompartmentRequest other = (ChangeSenderCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.senderId, other.senderId) && Objects.equals((Object)this.changeSenderCompartmentDetails, (Object)other.changeSenderCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.senderId == null ? 43 : this.senderId.hashCode());
        result = result * 59 + (this.changeSenderCompartmentDetails == null ? 43 : this.changeSenderCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeSenderCompartmentRequest, ChangeSenderCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String senderId = null;
        private ChangeSenderCompartmentDetails changeSenderCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder changeSenderCompartmentDetails(ChangeSenderCompartmentDetails changeSenderCompartmentDetails) {
            this.changeSenderCompartmentDetails = changeSenderCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeSenderCompartmentRequest o) {
            this.senderId(o.getSenderId());
            this.changeSenderCompartmentDetails(o.getChangeSenderCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeSenderCompartmentRequest build() {
            ChangeSenderCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeSenderCompartmentDetails body) {
            this.changeSenderCompartmentDetails(body);
            return this;
        }

        public ChangeSenderCompartmentRequest buildWithoutInvocationCallback() {
            ChangeSenderCompartmentRequest request = new ChangeSenderCompartmentRequest();
            request.senderId = this.senderId;
            request.changeSenderCompartmentDetails = this.changeSenderCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

