/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emaildataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.emaildataplane.model.EmailAddress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Recipients
extends ExplicitlySetBmcModel {
    @JsonProperty(value="to")
    private final List<EmailAddress> to;
    @JsonProperty(value="cc")
    private final List<EmailAddress> cc;
    @JsonProperty(value="bcc")
    private final List<EmailAddress> bcc;

    @Deprecated
    @ConstructorProperties(value={"to", "cc", "bcc"})
    public Recipients(List<EmailAddress> to, List<EmailAddress> cc, List<EmailAddress> bcc) {
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<EmailAddress> getTo() {
        return this.to;
    }

    public List<EmailAddress> getCc() {
        return this.cc;
    }

    public List<EmailAddress> getBcc() {
        return this.bcc;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Recipients(");
        sb.append("super=").append(super.toString());
        sb.append("to=").append(String.valueOf(this.to));
        sb.append(", cc=").append(String.valueOf(this.cc));
        sb.append(", bcc=").append(String.valueOf(this.bcc));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Recipients)) {
            return false;
        }
        Recipients other = (Recipients)((Object)o);
        return Objects.equals(this.to, other.to) && Objects.equals(this.cc, other.cc) && Objects.equals(this.bcc, other.bcc) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.to == null ? 43 : this.to.hashCode());
        result = result * 59 + (this.cc == null ? 43 : this.cc.hashCode());
        result = result * 59 + (this.bcc == null ? 43 : this.bcc.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="to")
        private List<EmailAddress> to;
        @JsonProperty(value="cc")
        private List<EmailAddress> cc;
        @JsonProperty(value="bcc")
        private List<EmailAddress> bcc;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder to(List<EmailAddress> to) {
            this.to = to;
            this.__explicitlySet__.add("to");
            return this;
        }

        public Builder cc(List<EmailAddress> cc) {
            this.cc = cc;
            this.__explicitlySet__.add("cc");
            return this;
        }

        public Builder bcc(List<EmailAddress> bcc) {
            this.bcc = bcc;
            this.__explicitlySet__.add("bcc");
            return this;
        }

        public Recipients build() {
            Recipients model = new Recipients(this.to, this.cc, this.bcc);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Recipients model) {
            if (model.wasPropertyExplicitlySet("to")) {
                this.to(model.getTo());
            }
            if (model.wasPropertyExplicitlySet("cc")) {
                this.cc(model.getCc());
            }
            if (model.wasPropertyExplicitlySet("bcc")) {
                this.bcc(model.getBcc());
            }
            return this;
        }
    }
}

