/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emaildataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.emaildataplane.model.EmailAddress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Sender
extends ExplicitlySetBmcModel {
    @JsonProperty(value="senderAddress")
    private final EmailAddress senderAddress;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    @Deprecated
    @ConstructorProperties(value={"senderAddress", "compartmentId"})
    public Sender(EmailAddress senderAddress, String compartmentId) {
        this.senderAddress = senderAddress;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public EmailAddress getSenderAddress() {
        return this.senderAddress;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Sender(");
        sb.append("super=").append(super.toString());
        sb.append("senderAddress=").append(String.valueOf((Object)this.senderAddress));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sender)) {
            return false;
        }
        Sender other = (Sender)((Object)o);
        return Objects.equals((Object)this.senderAddress, (Object)other.senderAddress) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.senderAddress == null ? 43 : this.senderAddress.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="senderAddress")
        private EmailAddress senderAddress;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder senderAddress(EmailAddress senderAddress) {
            this.senderAddress = senderAddress;
            this.__explicitlySet__.add("senderAddress");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Sender build() {
            Sender model = new Sender(this.senderAddress, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Sender model) {
            if (model.wasPropertyExplicitlySet("senderAddress")) {
                this.senderAddress(model.getSenderAddress());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

