/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emaildataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.emaildataplane.model.EmailAddress;
import com.oracle.bmc.emaildataplane.model.Recipients;
import com.oracle.bmc.emaildataplane.model.Sender;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SubmitEmailDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="messageId")
    private final String messageId;
    @JsonProperty(value="sender")
    private final Sender sender;
    @JsonProperty(value="recipients")
    private final Recipients recipients;
    @JsonProperty(value="subject")
    private final String subject;
    @JsonProperty(value="bodyHtml")
    private final String bodyHtml;
    @JsonProperty(value="bodyText")
    private final String bodyText;
    @JsonProperty(value="replyTo")
    private final List<EmailAddress> replyTo;
    @JsonProperty(value="headerFields")
    private final Map<String, String> headerFields;

    @Deprecated
    @ConstructorProperties(value={"messageId", "sender", "recipients", "subject", "bodyHtml", "bodyText", "replyTo", "headerFields"})
    public SubmitEmailDetails(String messageId, Sender sender, Recipients recipients, String subject, String bodyHtml, String bodyText, List<EmailAddress> replyTo, Map<String, String> headerFields) {
        this.messageId = messageId;
        this.sender = sender;
        this.recipients = recipients;
        this.subject = subject;
        this.bodyHtml = bodyHtml;
        this.bodyText = bodyText;
        this.replyTo = replyTo;
        this.headerFields = headerFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Sender getSender() {
        return this.sender;
    }

    public Recipients getRecipients() {
        return this.recipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public List<EmailAddress> getReplyTo() {
        return this.replyTo;
    }

    public Map<String, String> getHeaderFields() {
        return this.headerFields;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubmitEmailDetails(");
        sb.append("super=").append(super.toString());
        sb.append("messageId=").append(String.valueOf(this.messageId));
        sb.append(", sender=").append(String.valueOf((Object)this.sender));
        sb.append(", recipients=").append(String.valueOf((Object)this.recipients));
        sb.append(", subject=").append(String.valueOf(this.subject));
        sb.append(", bodyHtml=").append(String.valueOf(this.bodyHtml));
        sb.append(", bodyText=").append(String.valueOf(this.bodyText));
        sb.append(", replyTo=").append(String.valueOf(this.replyTo));
        sb.append(", headerFields=").append(String.valueOf(this.headerFields));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubmitEmailDetails)) {
            return false;
        }
        SubmitEmailDetails other = (SubmitEmailDetails)((Object)o);
        return Objects.equals(this.messageId, other.messageId) && Objects.equals((Object)this.sender, (Object)other.sender) && Objects.equals((Object)this.recipients, (Object)other.recipients) && Objects.equals(this.subject, other.subject) && Objects.equals(this.bodyHtml, other.bodyHtml) && Objects.equals(this.bodyText, other.bodyText) && Objects.equals(this.replyTo, other.replyTo) && Objects.equals(this.headerFields, other.headerFields) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.messageId == null ? 43 : this.messageId.hashCode());
        result = result * 59 + (this.sender == null ? 43 : this.sender.hashCode());
        result = result * 59 + (this.recipients == null ? 43 : this.recipients.hashCode());
        result = result * 59 + (this.subject == null ? 43 : this.subject.hashCode());
        result = result * 59 + (this.bodyHtml == null ? 43 : this.bodyHtml.hashCode());
        result = result * 59 + (this.bodyText == null ? 43 : this.bodyText.hashCode());
        result = result * 59 + (this.replyTo == null ? 43 : this.replyTo.hashCode());
        result = result * 59 + (this.headerFields == null ? 43 : this.headerFields.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="messageId")
        private String messageId;
        @JsonProperty(value="sender")
        private Sender sender;
        @JsonProperty(value="recipients")
        private Recipients recipients;
        @JsonProperty(value="subject")
        private String subject;
        @JsonProperty(value="bodyHtml")
        private String bodyHtml;
        @JsonProperty(value="bodyText")
        private String bodyText;
        @JsonProperty(value="replyTo")
        private List<EmailAddress> replyTo;
        @JsonProperty(value="headerFields")
        private Map<String, String> headerFields;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            this.__explicitlySet__.add("messageId");
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            this.__explicitlySet__.add("sender");
            return this;
        }

        public Builder recipients(Recipients recipients) {
            this.recipients = recipients;
            this.__explicitlySet__.add("recipients");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.__explicitlySet__.add("subject");
            return this;
        }

        public Builder bodyHtml(String bodyHtml) {
            this.bodyHtml = bodyHtml;
            this.__explicitlySet__.add("bodyHtml");
            return this;
        }

        public Builder bodyText(String bodyText) {
            this.bodyText = bodyText;
            this.__explicitlySet__.add("bodyText");
            return this;
        }

        public Builder replyTo(List<EmailAddress> replyTo) {
            this.replyTo = replyTo;
            this.__explicitlySet__.add("replyTo");
            return this;
        }

        public Builder headerFields(Map<String, String> headerFields) {
            this.headerFields = headerFields;
            this.__explicitlySet__.add("headerFields");
            return this;
        }

        public SubmitEmailDetails build() {
            SubmitEmailDetails model = new SubmitEmailDetails(this.messageId, this.sender, this.recipients, this.subject, this.bodyHtml, this.bodyText, this.replyTo, this.headerFields);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubmitEmailDetails model) {
            if (model.wasPropertyExplicitlySet("messageId")) {
                this.messageId(model.getMessageId());
            }
            if (model.wasPropertyExplicitlySet("sender")) {
                this.sender(model.getSender());
            }
            if (model.wasPropertyExplicitlySet("recipients")) {
                this.recipients(model.getRecipients());
            }
            if (model.wasPropertyExplicitlySet("subject")) {
                this.subject(model.getSubject());
            }
            if (model.wasPropertyExplicitlySet("bodyHtml")) {
                this.bodyHtml(model.getBodyHtml());
            }
            if (model.wasPropertyExplicitlySet("bodyText")) {
                this.bodyText(model.getBodyText());
            }
            if (model.wasPropertyExplicitlySet("replyTo")) {
                this.replyTo(model.getReplyTo());
            }
            if (model.wasPropertyExplicitlySet("headerFields")) {
                this.headerFields(model.getHeaderFields());
            }
            return this;
        }
    }
}

