/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emaildataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.emaildataplane.model.EmailAddress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EmailSubmittedResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="messageId")
    private final String messageId;
    @JsonProperty(value="envelopeId")
    private final String envelopeId;
    @JsonProperty(value="suppressedRecipients")
    private final List<EmailAddress> suppressedRecipients;

    @Deprecated
    @ConstructorProperties(value={"messageId", "envelopeId", "suppressedRecipients"})
    public EmailSubmittedResponse(String messageId, String envelopeId, List<EmailAddress> suppressedRecipients) {
        this.messageId = messageId;
        this.envelopeId = envelopeId;
        this.suppressedRecipients = suppressedRecipients;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getEnvelopeId() {
        return this.envelopeId;
    }

    public List<EmailAddress> getSuppressedRecipients() {
        return this.suppressedRecipients;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EmailSubmittedResponse(");
        sb.append("super=").append(super.toString());
        sb.append("messageId=").append(String.valueOf(this.messageId));
        sb.append(", envelopeId=").append(String.valueOf(this.envelopeId));
        sb.append(", suppressedRecipients=").append(String.valueOf(this.suppressedRecipients));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailSubmittedResponse)) {
            return false;
        }
        EmailSubmittedResponse other = (EmailSubmittedResponse)((Object)o);
        return Objects.equals(this.messageId, other.messageId) && Objects.equals(this.envelopeId, other.envelopeId) && Objects.equals(this.suppressedRecipients, other.suppressedRecipients) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.messageId == null ? 43 : this.messageId.hashCode());
        result = result * 59 + (this.envelopeId == null ? 43 : this.envelopeId.hashCode());
        result = result * 59 + (this.suppressedRecipients == null ? 43 : this.suppressedRecipients.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="messageId")
        private String messageId;
        @JsonProperty(value="envelopeId")
        private String envelopeId;
        @JsonProperty(value="suppressedRecipients")
        private List<EmailAddress> suppressedRecipients;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            this.__explicitlySet__.add("messageId");
            return this;
        }

        public Builder envelopeId(String envelopeId) {
            this.envelopeId = envelopeId;
            this.__explicitlySet__.add("envelopeId");
            return this;
        }

        public Builder suppressedRecipients(List<EmailAddress> suppressedRecipients) {
            this.suppressedRecipients = suppressedRecipients;
            this.__explicitlySet__.add("suppressedRecipients");
            return this;
        }

        public EmailSubmittedResponse build() {
            EmailSubmittedResponse model = new EmailSubmittedResponse(this.messageId, this.envelopeId, this.suppressedRecipients);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EmailSubmittedResponse model) {
            if (model.wasPropertyExplicitlySet("messageId")) {
                this.messageId(model.getMessageId());
            }
            if (model.wasPropertyExplicitlySet("envelopeId")) {
                this.envelopeId(model.getEnvelopeId());
            }
            if (model.wasPropertyExplicitlySet("suppressedRecipients")) {
                this.suppressedRecipients(model.getSuppressedRecipients());
            }
            return this;
        }
    }
}

