/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emwarehouse;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.emwarehouse.EmWarehouseAsync;
import com.oracle.bmc.emwarehouse.model.EmWarehouse;
import com.oracle.bmc.emwarehouse.model.EmWarehouseCollection;
import com.oracle.bmc.emwarehouse.model.EtlRunCollection;
import com.oracle.bmc.emwarehouse.model.ResourceUsage;
import com.oracle.bmc.emwarehouse.model.WorkRequest;
import com.oracle.bmc.emwarehouse.model.WorkRequestErrorCollection;
import com.oracle.bmc.emwarehouse.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.emwarehouse.model.WorkRequestSummaryCollection;
import com.oracle.bmc.emwarehouse.requests.CancelWorkRequestRequest;
import com.oracle.bmc.emwarehouse.requests.ChangeEmWarehouseCompartmentRequest;
import com.oracle.bmc.emwarehouse.requests.CreateEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.requests.DeleteEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.requests.GetEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.requests.GetEmWarehouseResourceUsageRequest;
import com.oracle.bmc.emwarehouse.requests.GetWorkRequestRequest;
import com.oracle.bmc.emwarehouse.requests.ListEmWarehousesRequest;
import com.oracle.bmc.emwarehouse.requests.ListEtlRunsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestsRequest;
import com.oracle.bmc.emwarehouse.requests.UpdateEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.responses.CancelWorkRequestResponse;
import com.oracle.bmc.emwarehouse.responses.ChangeEmWarehouseCompartmentResponse;
import com.oracle.bmc.emwarehouse.responses.CreateEmWarehouseResponse;
import com.oracle.bmc.emwarehouse.responses.DeleteEmWarehouseResponse;
import com.oracle.bmc.emwarehouse.responses.GetEmWarehouseResourceUsageResponse;
import com.oracle.bmc.emwarehouse.responses.GetEmWarehouseResponse;
import com.oracle.bmc.emwarehouse.responses.GetWorkRequestResponse;
import com.oracle.bmc.emwarehouse.responses.ListEmWarehousesResponse;
import com.oracle.bmc.emwarehouse.responses.ListEtlRunsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestsResponse;
import com.oracle.bmc.emwarehouse.responses.UpdateEmWarehouseResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmWarehouseAsyncClient
extends BaseAsyncClient
implements EmWarehouseAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EMWAREHOUSE").serviceEndpointPrefix("").serviceEndpointTemplate("https://operationsinsights.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EmWarehouseAsyncClient.class);

    EmWarehouseAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("EmWarehouse", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeEmWarehouseCompartmentResponse> changeEmWarehouseCompartment(ChangeEmWarehouseCompartmentRequest request, AsyncHandler<ChangeEmWarehouseCompartmentRequest, ChangeEmWarehouseCompartmentResponse> handler) {
        Validate.notBlank((String)request.getEmWarehouseId(), (String)"emWarehouseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeEmWarehouseCompartmentDetails(), "changeEmWarehouseCompartmentDetails is required");
        return this.clientCall(request, ChangeEmWarehouseCompartmentResponse::builder).logger(LOG, "changeEmWarehouseCompartment").serviceDetails("EmWarehouse", "ChangeEmWarehouseCompartment", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/EmWarehouse/ChangeEmWarehouseCompartment").method(Method.POST).requestBuilder(ChangeEmWarehouseCompartmentRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").appendPathParam(request.getEmWarehouseId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeEmWarehouseCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeEmWarehouseCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEmWarehouseResponse> createEmWarehouse(CreateEmWarehouseRequest request, AsyncHandler<CreateEmWarehouseRequest, CreateEmWarehouseResponse> handler) {
        Objects.requireNonNull(request.getCreateEmWarehouseDetails(), "createEmWarehouseDetails is required");
        return this.clientCall(request, CreateEmWarehouseResponse::builder).logger(LOG, "createEmWarehouse").serviceDetails("EmWarehouse", "CreateEmWarehouse", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/EmWarehouse/CreateEmWarehouse").method(Method.POST).requestBuilder(CreateEmWarehouseRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateEmWarehouseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateEmWarehouseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteEmWarehouseResponse> deleteEmWarehouse(DeleteEmWarehouseRequest request, AsyncHandler<DeleteEmWarehouseRequest, DeleteEmWarehouseResponse> handler) {
        Validate.notBlank((String)request.getEmWarehouseId(), (String)"emWarehouseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteEmWarehouseResponse::builder).logger(LOG, "deleteEmWarehouse").serviceDetails("EmWarehouse", "DeleteEmWarehouse", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/EmWarehouse/DeleteEmWarehouse").method(Method.DELETE).requestBuilder(DeleteEmWarehouseRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").appendPathParam(request.getEmWarehouseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteEmWarehouseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEmWarehouseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEmWarehouseResponse> getEmWarehouse(GetEmWarehouseRequest request, AsyncHandler<GetEmWarehouseRequest, GetEmWarehouseResponse> handler) {
        Validate.notBlank((String)request.getEmWarehouseId(), (String)"emWarehouseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEmWarehouseResponse::builder).logger(LOG, "getEmWarehouse").serviceDetails("EmWarehouse", "GetEmWarehouse", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/EmWarehouse/GetEmWarehouse").method(Method.GET).requestBuilder(GetEmWarehouseRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").appendPathParam(request.getEmWarehouseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EmWarehouse.class, GetEmWarehouseResponse.Builder::emWarehouse).handleResponseHeaderString("etag", GetEmWarehouseResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEmWarehouseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEmWarehouseResourceUsageResponse> getEmWarehouseResourceUsage(GetEmWarehouseResourceUsageRequest request, AsyncHandler<GetEmWarehouseResourceUsageRequest, GetEmWarehouseResourceUsageResponse> handler) {
        Validate.notBlank((String)request.getEmWarehouseId(), (String)"emWarehouseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEmWarehouseResourceUsageResponse::builder).logger(LOG, "getEmWarehouseResourceUsage").serviceDetails("EmWarehouse", "GetEmWarehouseResourceUsage", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/ResourceUsage/GetEmWarehouseResourceUsage").method(Method.GET).requestBuilder(GetEmWarehouseResourceUsageRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").appendPathParam(request.getEmWarehouseId()).appendPathParam("resourceUsage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceUsage.class, GetEmWarehouseResourceUsageResponse.Builder::resourceUsage).handleResponseHeaderString("etag", GetEmWarehouseResourceUsageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEmWarehouseResourceUsageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("EmWarehouse", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListEmWarehousesResponse> listEmWarehouses(ListEmWarehousesRequest request, AsyncHandler<ListEmWarehousesRequest, ListEmWarehousesResponse> handler) {
        return this.clientCall(request, ListEmWarehousesResponse::builder).logger(LOG, "listEmWarehouses").serviceDetails("EmWarehouse", "ListEmWarehouses", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/EmWarehouseCollection/ListEmWarehouses").method(Method.GET).requestBuilder(ListEmWarehousesRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("operationsInsightsWarehouseId", (Object)request.getOperationsInsightsWarehouseId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EmWarehouseCollection.class, ListEmWarehousesResponse.Builder::emWarehouseCollection).handleResponseHeaderString("opc-request-id", ListEmWarehousesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEmWarehousesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListEtlRunsResponse> listEtlRuns(ListEtlRunsRequest request, AsyncHandler<ListEtlRunsRequest, ListEtlRunsResponse> handler) {
        Validate.notBlank((String)request.getEmWarehouseId(), (String)"emWarehouseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListEtlRunsResponse::builder).logger(LOG, "listEtlRuns").serviceDetails("EmWarehouse", "ListEtlRuns", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/EtlRunCollection/ListEtlRuns").method(Method.GET).requestBuilder(ListEtlRunsRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").appendPathParam(request.getEmWarehouseId()).appendPathParam("etlRuns").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EtlRunCollection.class, ListEtlRunsResponse.Builder::etlRunCollection).handleResponseHeaderString("opc-request-id", ListEtlRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEtlRunsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("EmWarehouse", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("EmWarehouse", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("EmWarehouse", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateEmWarehouseResponse> updateEmWarehouse(UpdateEmWarehouseRequest request, AsyncHandler<UpdateEmWarehouseRequest, UpdateEmWarehouseResponse> handler) {
        Validate.notBlank((String)request.getEmWarehouseId(), (String)"emWarehouseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEmWarehouseDetails(), "updateEmWarehouseDetails is required");
        return this.clientCall(request, UpdateEmWarehouseResponse::builder).logger(LOG, "updateEmWarehouse").serviceDetails("EmWarehouse", "UpdateEmWarehouse", "https://docs.oracle.com/iaas/api/#/en/em-warehouse/20180828/EmWarehouse/UpdateEmWarehouse").method(Method.PUT).requestBuilder(UpdateEmWarehouseRequest::builder).basePath("/20180828").appendPathParam("emWarehouses").appendPathParam(request.getEmWarehouseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateEmWarehouseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateEmWarehouseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public EmWarehouseAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EmWarehouseAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EmWarehouseAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EmWarehouseAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EmWarehouseAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EmWarehouseAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EmWarehouseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EmWarehouseAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public EmWarehouseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EmWarehouseAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public EmWarehouseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EmWarehouseAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public EmWarehouseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EmWarehouseAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EmWarehouseAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "emwarehouse";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"emwarehouse");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public EmWarehouseAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EmWarehouseAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

