/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emwarehouse;

import com.oracle.bmc.emwarehouse.EmWarehouse;
import com.oracle.bmc.emwarehouse.model.EmWarehouse;
import com.oracle.bmc.emwarehouse.requests.GetEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.requests.GetWorkRequestRequest;
import com.oracle.bmc.emwarehouse.responses.GetEmWarehouseResponse;
import com.oracle.bmc.emwarehouse.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class EmWarehouseWaiters {
    private final ExecutorService executorService;
    private final EmWarehouse client;

    public EmWarehouseWaiters(ExecutorService executorService, EmWarehouse client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetEmWarehouseRequest, GetEmWarehouseResponse> forEmWarehouse(GetEmWarehouseRequest request, EmWarehouse.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEmWarehouse(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEmWarehouseRequest, GetEmWarehouseResponse> forEmWarehouse(GetEmWarehouseRequest request, EmWarehouse.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEmWarehouse(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEmWarehouseRequest, GetEmWarehouseResponse> forEmWarehouse(GetEmWarehouseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, EmWarehouse.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEmWarehouse(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEmWarehouseRequest, GetEmWarehouseResponse> forEmWarehouse(BmcGenericWaiter waiter, GetEmWarehouseRequest request, EmWarehouse.LifecycleState ... targetStates) {
        final HashSet<EmWarehouse.LifecycleState> targetStatesSet = new HashSet<EmWarehouse.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEmWarehouseRequest, GetEmWarehouseResponse>(){

            @Override
            public GetEmWarehouseResponse apply(GetEmWarehouseRequest request) {
                return EmWarehouseWaiters.this.client.getEmWarehouse(request);
            }
        }, (Predicate)new Predicate<GetEmWarehouseResponse>(){

            @Override
            public boolean test(GetEmWarehouseResponse response) {
                return targetStatesSet.contains((Object)response.getEmWarehouse().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)EmWarehouse.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return EmWarehouseWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

