/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emwarehouse.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EmInstancesDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="emId")
    private final String emId;
    @JsonProperty(value="targetsCount")
    private final Integer targetsCount;
    @JsonProperty(value="emHost")
    private final String emHost;
    @JsonProperty(value="emDiscovererUrl")
    private final String emDiscovererUrl;

    @Deprecated
    @ConstructorProperties(value={"emId", "targetsCount", "emHost", "emDiscovererUrl"})
    public EmInstancesDetails(String emId, Integer targetsCount, String emHost, String emDiscovererUrl) {
        this.emId = emId;
        this.targetsCount = targetsCount;
        this.emHost = emHost;
        this.emDiscovererUrl = emDiscovererUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEmId() {
        return this.emId;
    }

    public Integer getTargetsCount() {
        return this.targetsCount;
    }

    public String getEmHost() {
        return this.emHost;
    }

    public String getEmDiscovererUrl() {
        return this.emDiscovererUrl;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EmInstancesDetails(");
        sb.append("super=").append(super.toString());
        sb.append("emId=").append(String.valueOf(this.emId));
        sb.append(", targetsCount=").append(String.valueOf(this.targetsCount));
        sb.append(", emHost=").append(String.valueOf(this.emHost));
        sb.append(", emDiscovererUrl=").append(String.valueOf(this.emDiscovererUrl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmInstancesDetails)) {
            return false;
        }
        EmInstancesDetails other = (EmInstancesDetails)((Object)o);
        return Objects.equals(this.emId, other.emId) && Objects.equals(this.targetsCount, other.targetsCount) && Objects.equals(this.emHost, other.emHost) && Objects.equals(this.emDiscovererUrl, other.emDiscovererUrl) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.emId == null ? 43 : this.emId.hashCode());
        result = result * 59 + (this.targetsCount == null ? 43 : this.targetsCount.hashCode());
        result = result * 59 + (this.emHost == null ? 43 : this.emHost.hashCode());
        result = result * 59 + (this.emDiscovererUrl == null ? 43 : this.emDiscovererUrl.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="emId")
        private String emId;
        @JsonProperty(value="targetsCount")
        private Integer targetsCount;
        @JsonProperty(value="emHost")
        private String emHost;
        @JsonProperty(value="emDiscovererUrl")
        private String emDiscovererUrl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder emId(String emId) {
            this.emId = emId;
            this.__explicitlySet__.add("emId");
            return this;
        }

        public Builder targetsCount(Integer targetsCount) {
            this.targetsCount = targetsCount;
            this.__explicitlySet__.add("targetsCount");
            return this;
        }

        public Builder emHost(String emHost) {
            this.emHost = emHost;
            this.__explicitlySet__.add("emHost");
            return this;
        }

        public Builder emDiscovererUrl(String emDiscovererUrl) {
            this.emDiscovererUrl = emDiscovererUrl;
            this.__explicitlySet__.add("emDiscovererUrl");
            return this;
        }

        public EmInstancesDetails build() {
            EmInstancesDetails model = new EmInstancesDetails(this.emId, this.targetsCount, this.emHost, this.emDiscovererUrl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EmInstancesDetails model) {
            if (model.wasPropertyExplicitlySet("emId")) {
                this.emId(model.getEmId());
            }
            if (model.wasPropertyExplicitlySet("targetsCount")) {
                this.targetsCount(model.getTargetsCount());
            }
            if (model.wasPropertyExplicitlySet("emHost")) {
                this.emHost(model.getEmHost());
            }
            if (model.wasPropertyExplicitlySet("emDiscovererUrl")) {
                this.emDiscovererUrl(model.getEmDiscovererUrl());
            }
            return this;
        }
    }
}

