/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.encryption.KmsMasterKey;
import com.oracle.bmc.encryption.MasterKeyProvider;
import com.oracle.bmc.encryption.internal.DataKey;
import com.oracle.bmc.encryption.internal.EncryptionHeader;
import java.beans.ConstructorProperties;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class CipherHandler {
    protected final Cipher cipher;
    protected final MasterKeyProvider provider;

    public CipherHandler(MasterKeyProvider provider) {
        this.provider = provider;
        try {
            this.cipher = Cipher.getInstance(provider.getCryptoAlgorithm().getMode());
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Faild to create GCM cipher algorithm", ex);
        }
    }

    protected byte[] generateIV() {
        byte[] iv = new byte[this.provider.getCryptoAlgorithm().getIvLen() * 8];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        return iv;
    }

    protected DataKey generateDataKey() {
        return this.provider.getMasterKey().generateDataEncryptionKey(this.provider.getCryptoAlgorithm());
    }

    private SecretKeySpec generateSecretKeySpec(DataKey dataKey) {
        byte[] secretKeyBytes = AuthUtils.base64Decode((String)dataKey.getPlaintext());
        return new SecretKeySpec(secretKeyBytes, this.provider.getCryptoAlgorithm().getAlgorithm());
    }

    protected SecretKeySpec getSecretKeySpec(EncryptionHeader encryptionHeader, KmsMasterKey decryptionKmsMasterKey) {
        String decryptDataKey = decryptionKmsMasterKey.decryptDataKey(encryptionHeader.getEncryptionKey().getEncryptedDataKey(), encryptionHeader.getEncryptionKey().getMasterKeyId());
        byte[] secretKeyBytes = AuthUtils.base64Decode((String)decryptDataKey);
        return new SecretKeySpec(secretKeyBytes, this.provider.getCryptoAlgorithm().getAlgorithm());
    }

    public Cipher initCipher(int mode, SecretKeySpec dataKeySpec, EncryptionHeader encryptionHeader) {
        String context = encryptionHeader.getAdditionalAuthenticatedData();
        GCMParameterSpec spec = new GCMParameterSpec(this.provider.getCryptoAlgorithm().getTagLen() * 8, encryptionHeader.getIvBytes());
        try {
            this.cipher.init(mode, (Key)dataKeySpec, spec);
            if (context != null && !context.isEmpty()) {
                this.cipher.updateAAD(context.getBytes());
            }
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Cipher.init Invalid Key.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Cipher.init Invalid Algorithm Parameter.", e);
        }
        return this.cipher;
    }

    public static final class WithEncryptionHeader<T> {
        private final T result;
        private final EncryptionHeader encryptionHeader;

        @ConstructorProperties(value={"result", "encryptionHeader"})
        public WithEncryptionHeader(T result, EncryptionHeader encryptionHeader) {
            this.result = result;
            this.encryptionHeader = encryptionHeader;
        }

        public T getResult() {
            return this.result;
        }

        public EncryptionHeader getEncryptionHeader() {
            return this.encryptionHeader;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithEncryptionHeader)) {
                return false;
            }
            WithEncryptionHeader other = (WithEncryptionHeader)o;
            T this$result = this.getResult();
            T other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            EncryptionHeader this$encryptionHeader = this.getEncryptionHeader();
            EncryptionHeader other$encryptionHeader = other.getEncryptionHeader();
            return !(this$encryptionHeader == null ? other$encryptionHeader != null : !this$encryptionHeader.equals(other$encryptionHeader));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            EncryptionHeader $encryptionHeader = this.getEncryptionHeader();
            result = result * 59 + ($encryptionHeader == null ? 43 : $encryptionHeader.hashCode());
            return result;
        }

        public String toString() {
            return "CipherHandler.WithEncryptionHeader(result=" + this.getResult() + ", encryptionHeader=" + this.getEncryptionHeader() + ")";
        }
    }
}

