/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import java.beans.ConstructorProperties;

public enum CryptoAlgorithm {
    AES_128_GCM_IV12_TAG16(0, "AES", "AES/GCM/NoPadding", 16, 12, 16, 0, 16),
    AES_192_GCM_IV12_TAG16(0, "AES", "AES/GCM/NoPadding", 24, 12, 16, 0, 16),
    AES_256_GCM_IV12_TAG16(0, "AES", "AES/GCM/NoPadding", 32, 12, 16, 0, 16);

    private final int algorithmId;
    private final String algorithm;
    private final String mode;
    private final int dataKeyLen;
    private final int ivLen;
    private final int tagLen;
    private final int padding;
    private final int blockSize;

    @ConstructorProperties(value={"algorithmId", "algorithm", "mode", "dataKeyLen", "ivLen", "tagLen", "padding", "blockSize"})
    private CryptoAlgorithm(int algorithmId, String algorithm, String mode, int dataKeyLen, int ivLen, int tagLen, int padding, int blockSize) {
        this.algorithmId = algorithmId;
        this.algorithm = algorithm;
        this.mode = mode;
        this.dataKeyLen = dataKeyLen;
        this.ivLen = ivLen;
        this.tagLen = tagLen;
        this.padding = padding;
        this.blockSize = blockSize;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    public int getDataKeyLen() {
        return this.dataKeyLen;
    }

    public int getIvLen() {
        return this.ivLen;
    }

    public int getTagLen() {
        return this.tagLen;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getBlockSize() {
        return this.blockSize;
    }
}

