/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.encryption.KmsMasterKey;
import com.oracle.bmc.encryption.MasterKeyProvider;
import com.oracle.bmc.encryption.OciCryptoInputStream;
import com.oracle.bmc.encryption.OciCryptoResult;
import com.oracle.bmc.encryption.internal.CipherHandler;
import com.oracle.bmc.encryption.internal.DecryptionStream;
import com.oracle.bmc.encryption.internal.EncryptionHeader;
import com.oracle.bmc.encryption.internal.EncryptionKey;
import com.oracle.bmc.encryption.internal.SerializeHeader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;

public class DecryptionHandler
extends CipherHandler {
    private final SerializeHeader serializeHeader;
    private final MasterKeyProvider provider;

    public DecryptionHandler(MasterKeyProvider provider) {
        super(provider);
        this.provider = provider;
        this.serializeHeader = new SerializeHeader(provider);
    }

    public CipherHandler.WithEncryptionHeader<OciCryptoInputStream> getDecryptInputStream(InputStream inputStream) throws IOException {
        EncryptionHeader encryptionHeader = this.serializeHeader.readHeader(inputStream);
        KmsMasterKey kmsMasterKey = this.createDecryptionKmsMasterKey(encryptionHeader);
        Cipher cipher = this.initCipher(2, super.getSecretKeySpec(encryptionHeader, kmsMasterKey), encryptionHeader);
        return new CipherHandler.WithEncryptionHeader<OciCryptoInputStream>(new DecryptionStream(inputStream, cipher, encryptionHeader), encryptionHeader);
    }

    public OciCryptoResult decrypt(byte[] dataWithHeader) throws IOException {
        ByteArrayInputStream decryptInputStream = new ByteArrayInputStream(dataWithHeader);
        EncryptionHeader encryptionHeader = this.serializeHeader.readHeader(decryptInputStream);
        KmsMasterKey kmsMasterKey = this.createDecryptionKmsMasterKey(encryptionHeader);
        Cipher cipher = this.initCipher(2, this.getSecretKeySpec(encryptionHeader, kmsMasterKey), encryptionHeader);
        DecryptionStream inputStream = new DecryptionStream(decryptInputStream, cipher, encryptionHeader);
        return new OciCryptoResult(inputStream.decrypt(), encryptionHeader);
    }

    private KmsMasterKey createDecryptionKmsMasterKey(EncryptionHeader encryptionHeader) {
        KmsMasterKey kmsMasterKey = (KmsMasterKey)this.provider.getMasterKey();
        EncryptionKey encryptionKey = encryptionHeader.getEncryptionKey();
        if (!(kmsMasterKey != null && kmsMasterKey.getVaultId().equals(encryptionKey.getVaultId()) && kmsMasterKey.getKmsMasterKeyId().equals(encryptionKey.getMasterKeyId()) && kmsMasterKey.getRegion().equals(encryptionKey.getRegion()))) {
            return new KmsMasterKey((BasicAuthenticationDetailsProvider)((AuthenticationDetailsProvider)this.provider.getAuthenticationProvider()), encryptionKey.getRegion(), encryptionKey.getVaultId(), encryptionKey.getMasterKeyId());
        }
        return (KmsMasterKey)this.provider.getMasterKey();
    }
}

