/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.events.Events;
import com.oracle.bmc.events.model.Rule;
import com.oracle.bmc.events.requests.GetRuleRequest;
import com.oracle.bmc.events.responses.GetRuleResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class EventsWaiters {
    private final ExecutorService executorService;
    private final Events client;

    public Waiter<GetRuleRequest, GetRuleResponse> forRule(GetRuleRequest request, Rule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRuleRequest, GetRuleResponse> forRule(GetRuleRequest request, Rule.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRuleRequest, GetRuleResponse> forRule(GetRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Rule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRuleRequest, GetRuleResponse> forRule(BmcGenericWaiter waiter, GetRuleRequest request, Rule.LifecycleState ... targetStates) {
        final HashSet<Rule.LifecycleState> targetStatesSet = new HashSet<Rule.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetRuleRequest, GetRuleResponse>(){

            public GetRuleResponse apply(GetRuleRequest request) {
                return EventsWaiters.this.client.getRule(request);
            }
        }, (Predicate)new Predicate<GetRuleResponse>(){

            public boolean apply(GetRuleResponse response) {
                return targetStatesSet.contains((Object)response.getRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Rule.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public EventsWaiters(ExecutorService executorService, Events client) {
        this.executorService = executorService;
        this.client = client;
    }
}

