/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events.requests;

import com.oracle.bmc.events.model.UpdateRuleDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateRuleRequest
extends BmcRequest {
    private String ruleId;
    private UpdateRuleDetails updateRuleDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"ruleId", "updateRuleDetails", "ifMatch", "opcRequestId"})
    UpdateRuleRequest(String ruleId, UpdateRuleDetails updateRuleDetails, String ifMatch, String opcRequestId) {
        this.ruleId = ruleId;
        this.updateRuleDetails = updateRuleDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public UpdateRuleDetails getUpdateRuleDetails() {
        return this.updateRuleDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String ruleId;
        private UpdateRuleDetails updateRuleDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRuleRequest o) {
            this.ruleId(o.getRuleId());
            this.updateRuleDetails(o.getUpdateRuleDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRuleRequest build() {
            UpdateRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder updateRuleDetails(UpdateRuleDetails updateRuleDetails) {
            this.updateRuleDetails = updateRuleDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateRuleRequest buildWithoutInvocationCallback() {
            return new UpdateRuleRequest(this.ruleId, this.updateRuleDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateRuleRequest.Builder(ruleId=" + this.ruleId + ", updateRuleDetails=" + this.updateRuleDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

