/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events.responses;

import com.oracle.bmc.events.model.Rule;
import java.beans.ConstructorProperties;

public class GetRuleResponse {
    private String etag;
    private String opcRequestId;
    private Rule rule;

    @ConstructorProperties(value={"etag", "opcRequestId", "rule"})
    GetRuleResponse(String etag, String opcRequestId, Rule rule) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.rule = rule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Rule getRule() {
        return this.rule;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Rule rule;

        public Builder copy(GetRuleResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.rule(o.getRule());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public GetRuleResponse build() {
            return new GetRuleResponse(this.etag, this.opcRequestId, this.rule);
        }

        public String toString() {
            return "GetRuleResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", rule=" + this.rule + ")";
        }
    }
}

