/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events.responses;

import com.oracle.bmc.events.model.RuleSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListRulesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<RuleSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListRulesResponse(String opcNextPage, String opcRequestId, List<RuleSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<RuleSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<RuleSummary> items;

        public Builder copy(ListRulesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<RuleSummary> items) {
            this.items = items;
            return this;
        }

        public ListRulesResponse build() {
            return new ListRulesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListRulesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

