/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.events.model.UpdateRuleDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRuleRequest
extends BmcRequest<UpdateRuleDetails> {
    private String ruleId;
    private UpdateRuleDetails updateRuleDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getRuleId() {
        return this.ruleId;
    }

    public UpdateRuleDetails getUpdateRuleDetails() {
        return this.updateRuleDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateRuleDetails getBody$() {
        return this.updateRuleDetails;
    }

    public Builder toBuilder() {
        return new Builder().ruleId(this.ruleId).updateRuleDetails(this.updateRuleDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ruleId=").append(String.valueOf(this.ruleId));
        sb.append(",updateRuleDetails=").append(String.valueOf((Object)this.updateRuleDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ruleId, other.ruleId) && Objects.equals((Object)this.updateRuleDetails, (Object)other.updateRuleDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ruleId == null ? 43 : this.ruleId.hashCode());
        result = result * 59 + (this.updateRuleDetails == null ? 43 : this.updateRuleDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRuleRequest, UpdateRuleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ruleId = null;
        private UpdateRuleDetails updateRuleDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder updateRuleDetails(UpdateRuleDetails updateRuleDetails) {
            this.updateRuleDetails = updateRuleDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRuleRequest o) {
            this.ruleId(o.getRuleId());
            this.updateRuleDetails(o.getUpdateRuleDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRuleRequest build() {
            UpdateRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRuleDetails body) {
            this.updateRuleDetails(body);
            return this;
        }

        public UpdateRuleRequest buildWithoutInvocationCallback() {
            UpdateRuleRequest request = new UpdateRuleRequest();
            request.ruleId = this.ruleId;
            request.updateRuleDetails = this.updateRuleDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

