/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementAdmin;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementAdminPaginators;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementAdminWaiters;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicy;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicyCollection;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicyRule;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicyRuleCollection;
import com.oracle.bmc.fleetappsmanagement.model.Onboarding;
import com.oracle.bmc.fleetappsmanagement.model.OnboardingCollection;
import com.oracle.bmc.fleetappsmanagement.model.OnboardingPolicyCollection;
import com.oracle.bmc.fleetappsmanagement.model.PlatformConfiguration;
import com.oracle.bmc.fleetappsmanagement.model.PlatformConfigurationCollection;
import com.oracle.bmc.fleetappsmanagement.model.Property;
import com.oracle.bmc.fleetappsmanagement.model.PropertyCollection;
import com.oracle.bmc.fleetappsmanagement.requests.CreateCompliancePolicyRuleRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreateOnboardingRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreatePlatformConfigurationRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreatePropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteCompliancePolicyRuleRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteOnboardingRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeletePlatformConfigurationRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeletePropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.EnableLatestPolicyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetCompliancePolicyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetCompliancePolicyRuleRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetOnboardingRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetPlatformConfigurationRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetPropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListCompliancePoliciesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListCompliancePolicyRulesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListOnboardingPoliciesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListOnboardingsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListPlatformConfigurationsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListPropertiesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ManageSettingsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateCompliancePolicyRuleRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateOnboardingRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdatePlatformConfigurationRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdatePropertyRequest;
import com.oracle.bmc.fleetappsmanagement.responses.CreateCompliancePolicyRuleResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreateOnboardingResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreatePlatformConfigurationResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreatePropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteCompliancePolicyRuleResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteOnboardingResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeletePlatformConfigurationResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeletePropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.EnableLatestPolicyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetCompliancePolicyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetCompliancePolicyRuleResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetOnboardingResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetPlatformConfigurationResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetPropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListCompliancePoliciesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListCompliancePolicyRulesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListOnboardingPoliciesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListOnboardingsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListPlatformConfigurationsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListPropertiesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ManageSettingsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateCompliancePolicyRuleResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateOnboardingResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdatePlatformConfigurationResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdatePropertyResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetAppsManagementAdminClient
extends BaseSyncClient
implements FleetAppsManagementAdmin {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETAPPSMANAGEMENTADMIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://fams.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetAppsManagementAdminClient.class);
    private final FleetAppsManagementAdminWaiters waiters;
    private final FleetAppsManagementAdminPaginators paginators;

    FleetAppsManagementAdminClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("FleetAppsManagementAdmin-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new FleetAppsManagementAdminWaiters(executorService, this);
        this.paginators = new FleetAppsManagementAdminPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateCompliancePolicyRuleResponse createCompliancePolicyRule(CreateCompliancePolicyRuleRequest request) {
        Objects.requireNonNull(request.getCreateCompliancePolicyRuleDetails(), "createCompliancePolicyRuleDetails is required");
        return (CreateCompliancePolicyRuleResponse)this.clientCall(request, CreateCompliancePolicyRuleResponse::builder).logger(LOG, "createCompliancePolicyRule").serviceDetails("FleetAppsManagementAdmin", "CreateCompliancePolicyRule", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/CompliancePolicyRule/CreateCompliancePolicyRule").method(Method.POST).requestBuilder(CreateCompliancePolicyRuleRequest::builder).basePath("/20230831").appendPathParam("compliancePolicyRules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(CompliancePolicyRule.class, CreateCompliancePolicyRuleResponse.Builder::compliancePolicyRule).handleResponseHeaderString("location", CreateCompliancePolicyRuleResponse.Builder::location).handleResponseHeaderString("content-location", CreateCompliancePolicyRuleResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateCompliancePolicyRuleResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateCompliancePolicyRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateCompliancePolicyRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOnboardingResponse createOnboarding(CreateOnboardingRequest request) {
        Objects.requireNonNull(request.getCreateOnboardingDetails(), "createOnboardingDetails is required");
        return (CreateOnboardingResponse)this.clientCall(request, CreateOnboardingResponse::builder).logger(LOG, "createOnboarding").serviceDetails("FleetAppsManagementAdmin", "CreateOnboarding", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Onboarding/CreateOnboarding").method(Method.POST).requestBuilder(CreateOnboardingRequest::builder).basePath("/20230831").appendPathParam("Onboardings").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Onboarding.class, CreateOnboardingResponse.Builder::onboarding).handleResponseHeaderString("location", CreateOnboardingResponse.Builder::location).handleResponseHeaderString("content-location", CreateOnboardingResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateOnboardingResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateOnboardingResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOnboardingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePlatformConfigurationResponse createPlatformConfiguration(CreatePlatformConfigurationRequest request) {
        Objects.requireNonNull(request.getCreatePlatformConfigurationDetails(), "createPlatformConfigurationDetails is required");
        return (CreatePlatformConfigurationResponse)this.clientCall(request, CreatePlatformConfigurationResponse::builder).logger(LOG, "createPlatformConfiguration").serviceDetails("FleetAppsManagementAdmin", "CreatePlatformConfiguration", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/PlatformConfiguration/CreatePlatformConfiguration").method(Method.POST).requestBuilder(CreatePlatformConfigurationRequest::builder).basePath("/20230831").appendPathParam("platformConfigurations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PlatformConfiguration.class, CreatePlatformConfigurationResponse.Builder::platformConfiguration).handleResponseHeaderString("etag", CreatePlatformConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePlatformConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePropertyResponse createProperty(CreatePropertyRequest request) {
        Objects.requireNonNull(request.getCreatePropertyDetails(), "createPropertyDetails is required");
        return (CreatePropertyResponse)this.clientCall(request, CreatePropertyResponse::builder).logger(LOG, "createProperty").serviceDetails("FleetAppsManagementAdmin", "CreateProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Property/CreateProperty").method(Method.POST).requestBuilder(CreatePropertyRequest::builder).basePath("/20230831").appendPathParam("properties").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Property.class, CreatePropertyResponse.Builder::property).handleResponseHeaderString("etag", CreatePropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCompliancePolicyRuleResponse deleteCompliancePolicyRule(DeleteCompliancePolicyRuleRequest request) {
        Validate.notBlank((String)request.getCompliancePolicyRuleId(), (String)"compliancePolicyRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteCompliancePolicyRuleResponse)this.clientCall(request, DeleteCompliancePolicyRuleResponse::builder).logger(LOG, "deleteCompliancePolicyRule").serviceDetails("FleetAppsManagementAdmin", "DeleteCompliancePolicyRule", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/CompliancePolicyRule/DeleteCompliancePolicyRule").method(Method.DELETE).requestBuilder(DeleteCompliancePolicyRuleRequest::builder).basePath("/20230831").appendPathParam("compliancePolicyRules").appendPathParam(request.getCompliancePolicyRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteCompliancePolicyRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCompliancePolicyRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteOnboardingResponse deleteOnboarding(DeleteOnboardingRequest request) {
        Validate.notBlank((String)request.getOnboardingId(), (String)"onboardingId must not be blank", (Object[])new Object[0]);
        return (DeleteOnboardingResponse)this.clientCall(request, DeleteOnboardingResponse::builder).logger(LOG, "deleteOnboarding").serviceDetails("FleetAppsManagementAdmin", "DeleteOnboarding", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Onboarding/DeleteOnboarding").method(Method.DELETE).requestBuilder(DeleteOnboardingRequest::builder).basePath("/20230831").appendPathParam("Onboardings").appendPathParam(request.getOnboardingId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteOnboardingResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOnboardingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePlatformConfigurationResponse deletePlatformConfiguration(DeletePlatformConfigurationRequest request) {
        Validate.notBlank((String)request.getPlatformConfigurationId(), (String)"platformConfigurationId must not be blank", (Object[])new Object[0]);
        return (DeletePlatformConfigurationResponse)this.clientCall(request, DeletePlatformConfigurationResponse::builder).logger(LOG, "deletePlatformConfiguration").serviceDetails("FleetAppsManagementAdmin", "DeletePlatformConfiguration", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/PlatformConfiguration/DeletePlatformConfiguration").method(Method.DELETE).requestBuilder(DeletePlatformConfigurationRequest::builder).basePath("/20230831").appendPathParam("platformConfigurations").appendPathParam(request.getPlatformConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeletePlatformConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePlatformConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePropertyResponse deleteProperty(DeletePropertyRequest request) {
        Validate.notBlank((String)request.getPropertyId(), (String)"propertyId must not be blank", (Object[])new Object[0]);
        return (DeletePropertyResponse)this.clientCall(request, DeletePropertyResponse::builder).logger(LOG, "deleteProperty").serviceDetails("FleetAppsManagementAdmin", "DeleteProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Property/DeleteProperty").method(Method.DELETE).requestBuilder(DeletePropertyRequest::builder).basePath("/20230831").appendPathParam("properties").appendPathParam(request.getPropertyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeletePropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EnableLatestPolicyResponse enableLatestPolicy(EnableLatestPolicyRequest request) {
        Validate.notBlank((String)request.getOnboardingId(), (String)"onboardingId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableLatestPolicyDetails(), "enableLatestPolicyDetails is required");
        return (EnableLatestPolicyResponse)this.clientCall(request, EnableLatestPolicyResponse::builder).logger(LOG, "enableLatestPolicy").serviceDetails("FleetAppsManagementAdmin", "EnableLatestPolicy", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Onboarding/EnableLatestPolicy").method(Method.POST).requestBuilder(EnableLatestPolicyRequest::builder).basePath("/20230831").appendPathParam("Onboardings").appendPathParam(request.getOnboardingId()).appendPathParam("actions").appendPathParam("enableLatestPolicy").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", EnableLatestPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCompliancePolicyResponse getCompliancePolicy(GetCompliancePolicyRequest request) {
        Validate.notBlank((String)request.getCompliancePolicyId(), (String)"compliancePolicyId must not be blank", (Object[])new Object[0]);
        return (GetCompliancePolicyResponse)this.clientCall(request, GetCompliancePolicyResponse::builder).logger(LOG, "getCompliancePolicy").serviceDetails("FleetAppsManagementAdmin", "GetCompliancePolicy", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/CompliancePolicy/GetCompliancePolicy").method(Method.GET).requestBuilder(GetCompliancePolicyRequest::builder).basePath("/20230831").appendPathParam("compliancePolicies").appendPathParam(request.getCompliancePolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CompliancePolicy.class, GetCompliancePolicyResponse.Builder::compliancePolicy).handleResponseHeaderString("etag", GetCompliancePolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCompliancePolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCompliancePolicyRuleResponse getCompliancePolicyRule(GetCompliancePolicyRuleRequest request) {
        Validate.notBlank((String)request.getCompliancePolicyRuleId(), (String)"compliancePolicyRuleId must not be blank", (Object[])new Object[0]);
        return (GetCompliancePolicyRuleResponse)this.clientCall(request, GetCompliancePolicyRuleResponse::builder).logger(LOG, "getCompliancePolicyRule").serviceDetails("FleetAppsManagementAdmin", "GetCompliancePolicyRule", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/CompliancePolicyRule/GetCompliancePolicyRule").method(Method.GET).requestBuilder(GetCompliancePolicyRuleRequest::builder).basePath("/20230831").appendPathParam("compliancePolicyRules").appendPathParam(request.getCompliancePolicyRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CompliancePolicyRule.class, GetCompliancePolicyRuleResponse.Builder::compliancePolicyRule).handleResponseHeaderString("etag", GetCompliancePolicyRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCompliancePolicyRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOnboardingResponse getOnboarding(GetOnboardingRequest request) {
        Validate.notBlank((String)request.getOnboardingId(), (String)"onboardingId must not be blank", (Object[])new Object[0]);
        return (GetOnboardingResponse)this.clientCall(request, GetOnboardingResponse::builder).logger(LOG, "getOnboarding").serviceDetails("FleetAppsManagementAdmin", "GetOnboarding", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Onboarding/GetOnboarding").method(Method.GET).requestBuilder(GetOnboardingRequest::builder).basePath("/20230831").appendPathParam("Onboardings").appendPathParam(request.getOnboardingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Onboarding.class, GetOnboardingResponse.Builder::onboarding).handleResponseHeaderString("etag", GetOnboardingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOnboardingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPlatformConfigurationResponse getPlatformConfiguration(GetPlatformConfigurationRequest request) {
        Validate.notBlank((String)request.getPlatformConfigurationId(), (String)"platformConfigurationId must not be blank", (Object[])new Object[0]);
        return (GetPlatformConfigurationResponse)this.clientCall(request, GetPlatformConfigurationResponse::builder).logger(LOG, "getPlatformConfiguration").serviceDetails("FleetAppsManagementAdmin", "GetPlatformConfiguration", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/PlatformConfiguration/GetPlatformConfiguration").method(Method.GET).requestBuilder(GetPlatformConfigurationRequest::builder).basePath("/20230831").appendPathParam("platformConfigurations").appendPathParam(request.getPlatformConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PlatformConfiguration.class, GetPlatformConfigurationResponse.Builder::platformConfiguration).handleResponseHeaderString("etag", GetPlatformConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPlatformConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPropertyResponse getProperty(GetPropertyRequest request) {
        Validate.notBlank((String)request.getPropertyId(), (String)"propertyId must not be blank", (Object[])new Object[0]);
        return (GetPropertyResponse)this.clientCall(request, GetPropertyResponse::builder).logger(LOG, "getProperty").serviceDetails("FleetAppsManagementAdmin", "GetProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Property/GetProperty").method(Method.GET).requestBuilder(GetPropertyRequest::builder).basePath("/20230831").appendPathParam("properties").appendPathParam(request.getPropertyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Property.class, GetPropertyResponse.Builder::property).handleResponseHeaderString("etag", GetPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCompliancePoliciesResponse listCompliancePolicies(ListCompliancePoliciesRequest request) {
        return (ListCompliancePoliciesResponse)this.clientCall(request, ListCompliancePoliciesResponse::builder).logger(LOG, "listCompliancePolicies").serviceDetails("FleetAppsManagementAdmin", "ListCompliancePolicies", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/CompliancePolicyCollection/ListCompliancePolicies").method(Method.GET).requestBuilder(ListCompliancePoliciesRequest::builder).basePath("/20230831").appendPathParam("compliancePolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CompliancePolicyCollection.class, ListCompliancePoliciesResponse.Builder::compliancePolicyCollection).handleResponseHeaderString("opc-request-id", ListCompliancePoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCompliancePoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListCompliancePolicyRulesResponse listCompliancePolicyRules(ListCompliancePolicyRulesRequest request) {
        return (ListCompliancePolicyRulesResponse)this.clientCall(request, ListCompliancePolicyRulesResponse::builder).logger(LOG, "listCompliancePolicyRules").serviceDetails("FleetAppsManagementAdmin", "ListCompliancePolicyRules", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/CompliancePolicyRuleCollection/ListCompliancePolicyRules").method(Method.GET).requestBuilder(ListCompliancePolicyRulesRequest::builder).basePath("/20230831").appendPathParam("compliancePolicyRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("patchName", (Object)request.getPatchName()).appendQueryParam("compliancePolicyId", (Object)request.getCompliancePolicyId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CompliancePolicyRuleCollection.class, ListCompliancePolicyRulesResponse.Builder::compliancePolicyRuleCollection).handleResponseHeaderString("opc-request-id", ListCompliancePolicyRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCompliancePolicyRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOnboardingPoliciesResponse listOnboardingPolicies(ListOnboardingPoliciesRequest request) {
        return (ListOnboardingPoliciesResponse)this.clientCall(request, ListOnboardingPoliciesResponse::builder).logger(LOG, "listOnboardingPolicies").serviceDetails("FleetAppsManagementAdmin", "ListOnboardingPolicies", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/OnboardingPolicyCollection/ListOnboardingPolicies").method(Method.GET).requestBuilder(ListOnboardingPoliciesRequest::builder).basePath("/20230831").appendPathParam("OnboardingPolicies").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OnboardingPolicyCollection.class, ListOnboardingPoliciesResponse.Builder::onboardingPolicyCollection).handleResponseHeaderString("opc-request-id", ListOnboardingPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOnboardingPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOnboardingsResponse listOnboardings(ListOnboardingsRequest request) {
        return (ListOnboardingsResponse)this.clientCall(request, ListOnboardingsResponse::builder).logger(LOG, "listOnboardings").serviceDetails("FleetAppsManagementAdmin", "ListOnboardings", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/OnboardingCollection/ListOnboardings").method(Method.GET).requestBuilder(ListOnboardingsRequest::builder).basePath("/20230831").appendPathParam("Onboardings").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OnboardingCollection.class, ListOnboardingsResponse.Builder::onboardingCollection).handleResponseHeaderString("opc-request-id", ListOnboardingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOnboardingsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPlatformConfigurationsResponse listPlatformConfigurations(ListPlatformConfigurationsRequest request) {
        return (ListPlatformConfigurationsResponse)this.clientCall(request, ListPlatformConfigurationsResponse::builder).logger(LOG, "listPlatformConfigurations").serviceDetails("FleetAppsManagementAdmin", "ListPlatformConfigurations", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/PlatformConfigurationCollection/ListPlatformConfigurations").method(Method.GET).requestBuilder(ListPlatformConfigurationsRequest::builder).basePath("/20230831").appendPathParam("platformConfigurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("configCategory", (BmcEnum)request.getConfigCategory()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PlatformConfigurationCollection.class, ListPlatformConfigurationsResponse.Builder::platformConfigurationCollection).handleResponseHeaderString("opc-request-id", ListPlatformConfigurationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPlatformConfigurationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPropertiesResponse listProperties(ListPropertiesRequest request) {
        return (ListPropertiesResponse)this.clientCall(request, ListPropertiesResponse::builder).logger(LOG, "listProperties").serviceDetails("FleetAppsManagementAdmin", "ListProperties", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/PropertyCollection/ListProperties").method(Method.GET).requestBuilder(ListPropertiesRequest::builder).basePath("/20230831").appendPathParam("properties").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PropertyCollection.class, ListPropertiesResponse.Builder::propertyCollection).handleResponseHeaderString("opc-request-id", ListPropertiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPropertiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ManageSettingsResponse manageSettings(ManageSettingsRequest request) {
        Validate.notBlank((String)request.getOnboardingId(), (String)"onboardingId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getManageSettingsDetails(), "manageSettingsDetails is required");
        return (ManageSettingsResponse)this.clientCall(request, ManageSettingsResponse::builder).logger(LOG, "manageSettings").serviceDetails("FleetAppsManagementAdmin", "ManageSettings", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Onboarding/ManageSettings").method(Method.POST).requestBuilder(ManageSettingsRequest::builder).basePath("/20230831").appendPathParam("Onboardings").appendPathParam(request.getOnboardingId()).appendPathParam("actions").appendPathParam("manageSettings").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ManageSettingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCompliancePolicyRuleResponse updateCompliancePolicyRule(UpdateCompliancePolicyRuleRequest request) {
        Validate.notBlank((String)request.getCompliancePolicyRuleId(), (String)"compliancePolicyRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCompliancePolicyRuleDetails(), "updateCompliancePolicyRuleDetails is required");
        return (UpdateCompliancePolicyRuleResponse)this.clientCall(request, UpdateCompliancePolicyRuleResponse::builder).logger(LOG, "updateCompliancePolicyRule").serviceDetails("FleetAppsManagementAdmin", "UpdateCompliancePolicyRule", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/CompliancePolicyRule/UpdateCompliancePolicyRule").method(Method.PUT).requestBuilder(UpdateCompliancePolicyRuleRequest::builder).basePath("/20230831").appendPathParam("compliancePolicyRules").appendPathParam(request.getCompliancePolicyRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateCompliancePolicyRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateCompliancePolicyRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateOnboardingResponse updateOnboarding(UpdateOnboardingRequest request) {
        Validate.notBlank((String)request.getOnboardingId(), (String)"onboardingId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOnboardingDetails(), "updateOnboardingDetails is required");
        return (UpdateOnboardingResponse)this.clientCall(request, UpdateOnboardingResponse::builder).logger(LOG, "updateOnboarding").serviceDetails("FleetAppsManagementAdmin", "UpdateOnboarding", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Onboarding/UpdateOnboarding").method(Method.PUT).requestBuilder(UpdateOnboardingRequest::builder).basePath("/20230831").appendPathParam("Onboardings").appendPathParam(request.getOnboardingId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOnboardingResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOnboardingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePlatformConfigurationResponse updatePlatformConfiguration(UpdatePlatformConfigurationRequest request) {
        Validate.notBlank((String)request.getPlatformConfigurationId(), (String)"platformConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePlatformConfigurationDetails(), "updatePlatformConfigurationDetails is required");
        return (UpdatePlatformConfigurationResponse)this.clientCall(request, UpdatePlatformConfigurationResponse::builder).logger(LOG, "updatePlatformConfiguration").serviceDetails("FleetAppsManagementAdmin", "UpdatePlatformConfiguration", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/PlatformConfiguration/UpdatePlatformConfiguration").method(Method.PUT).requestBuilder(UpdatePlatformConfigurationRequest::builder).basePath("/20230831").appendPathParam("platformConfigurations").appendPathParam(request.getPlatformConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdatePlatformConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdatePlatformConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePropertyResponse updateProperty(UpdatePropertyRequest request) {
        Validate.notBlank((String)request.getPropertyId(), (String)"propertyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePropertyDetails(), "updatePropertyDetails is required");
        return (UpdatePropertyResponse)this.clientCall(request, UpdatePropertyResponse::builder).logger(LOG, "updateProperty").serviceDetails("FleetAppsManagementAdmin", "UpdateProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Property/UpdateProperty").method(Method.PUT).requestBuilder(UpdatePropertyRequest::builder).basePath("/20230831").appendPathParam("properties").appendPathParam(request.getPropertyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Property.class, UpdatePropertyResponse.Builder::property).handleResponseHeaderString("etag", UpdatePropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public FleetAppsManagementAdminWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public FleetAppsManagementAdminPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public FleetAppsManagementAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetAppsManagementAdminClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetAppsManagementAdminClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetAppsManagementAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetAppsManagementAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetAppsManagementAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetAppsManagementAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetAppsManagementAdminClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "fleetappsmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetappsmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public FleetAppsManagementAdminClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetAppsManagementAdminClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

