/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementAdmin;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicyRuleSummary;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicySummary;
import com.oracle.bmc.fleetappsmanagement.model.OnboardingPolicySummary;
import com.oracle.bmc.fleetappsmanagement.model.OnboardingSummary;
import com.oracle.bmc.fleetappsmanagement.model.PlatformConfigurationSummary;
import com.oracle.bmc.fleetappsmanagement.model.PropertySummary;
import com.oracle.bmc.fleetappsmanagement.requests.ListCompliancePoliciesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListCompliancePolicyRulesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListOnboardingPoliciesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListOnboardingsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListPlatformConfigurationsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListPropertiesRequest;
import com.oracle.bmc.fleetappsmanagement.responses.ListCompliancePoliciesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListCompliancePolicyRulesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListOnboardingPoliciesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListOnboardingsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListPlatformConfigurationsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListPropertiesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class FleetAppsManagementAdminPaginators {
    private final FleetAppsManagementAdmin client;

    public FleetAppsManagementAdminPaginators(FleetAppsManagementAdmin client) {
        this.client = client;
    }

    public Iterable<ListCompliancePoliciesResponse> listCompliancePoliciesResponseIterator(final ListCompliancePoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCompliancePoliciesRequest.Builder>(){

            @Override
            public ListCompliancePoliciesRequest.Builder get() {
                return ListCompliancePoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCompliancePoliciesResponse, String>(){

            @Override
            public String apply(ListCompliancePoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCompliancePoliciesRequest.Builder>, ListCompliancePoliciesRequest>(){

            @Override
            public ListCompliancePoliciesRequest apply(RequestBuilderAndToken<ListCompliancePoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCompliancePoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCompliancePoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCompliancePoliciesRequest, ListCompliancePoliciesResponse>(){

            @Override
            public ListCompliancePoliciesResponse apply(ListCompliancePoliciesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listCompliancePolicies(request);
            }
        });
    }

    public Iterable<CompliancePolicySummary> listCompliancePoliciesRecordIterator(final ListCompliancePoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCompliancePoliciesRequest.Builder>(){

            @Override
            public ListCompliancePoliciesRequest.Builder get() {
                return ListCompliancePoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCompliancePoliciesResponse, String>(){

            @Override
            public String apply(ListCompliancePoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCompliancePoliciesRequest.Builder>, ListCompliancePoliciesRequest>(){

            @Override
            public ListCompliancePoliciesRequest apply(RequestBuilderAndToken<ListCompliancePoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCompliancePoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCompliancePoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCompliancePoliciesRequest, ListCompliancePoliciesResponse>(){

            @Override
            public ListCompliancePoliciesResponse apply(ListCompliancePoliciesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listCompliancePolicies(request);
            }
        }, (Function)new Function<ListCompliancePoliciesResponse, List<CompliancePolicySummary>>(){

            @Override
            public List<CompliancePolicySummary> apply(ListCompliancePoliciesResponse response) {
                return response.getCompliancePolicyCollection().getItems();
            }
        });
    }

    public Iterable<ListCompliancePolicyRulesResponse> listCompliancePolicyRulesResponseIterator(final ListCompliancePolicyRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCompliancePolicyRulesRequest.Builder>(){

            @Override
            public ListCompliancePolicyRulesRequest.Builder get() {
                return ListCompliancePolicyRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCompliancePolicyRulesResponse, String>(){

            @Override
            public String apply(ListCompliancePolicyRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCompliancePolicyRulesRequest.Builder>, ListCompliancePolicyRulesRequest>(){

            @Override
            public ListCompliancePolicyRulesRequest apply(RequestBuilderAndToken<ListCompliancePolicyRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCompliancePolicyRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCompliancePolicyRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCompliancePolicyRulesRequest, ListCompliancePolicyRulesResponse>(){

            @Override
            public ListCompliancePolicyRulesResponse apply(ListCompliancePolicyRulesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listCompliancePolicyRules(request);
            }
        });
    }

    public Iterable<CompliancePolicyRuleSummary> listCompliancePolicyRulesRecordIterator(final ListCompliancePolicyRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCompliancePolicyRulesRequest.Builder>(){

            @Override
            public ListCompliancePolicyRulesRequest.Builder get() {
                return ListCompliancePolicyRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCompliancePolicyRulesResponse, String>(){

            @Override
            public String apply(ListCompliancePolicyRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCompliancePolicyRulesRequest.Builder>, ListCompliancePolicyRulesRequest>(){

            @Override
            public ListCompliancePolicyRulesRequest apply(RequestBuilderAndToken<ListCompliancePolicyRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCompliancePolicyRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCompliancePolicyRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCompliancePolicyRulesRequest, ListCompliancePolicyRulesResponse>(){

            @Override
            public ListCompliancePolicyRulesResponse apply(ListCompliancePolicyRulesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listCompliancePolicyRules(request);
            }
        }, (Function)new Function<ListCompliancePolicyRulesResponse, List<CompliancePolicyRuleSummary>>(){

            @Override
            public List<CompliancePolicyRuleSummary> apply(ListCompliancePolicyRulesResponse response) {
                return response.getCompliancePolicyRuleCollection().getItems();
            }
        });
    }

    public Iterable<ListOnboardingPoliciesResponse> listOnboardingPoliciesResponseIterator(final ListOnboardingPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOnboardingPoliciesRequest.Builder>(){

            @Override
            public ListOnboardingPoliciesRequest.Builder get() {
                return ListOnboardingPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOnboardingPoliciesResponse, String>(){

            @Override
            public String apply(ListOnboardingPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOnboardingPoliciesRequest.Builder>, ListOnboardingPoliciesRequest>(){

            @Override
            public ListOnboardingPoliciesRequest apply(RequestBuilderAndToken<ListOnboardingPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOnboardingPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOnboardingPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOnboardingPoliciesRequest, ListOnboardingPoliciesResponse>(){

            @Override
            public ListOnboardingPoliciesResponse apply(ListOnboardingPoliciesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listOnboardingPolicies(request);
            }
        });
    }

    public Iterable<OnboardingPolicySummary> listOnboardingPoliciesRecordIterator(final ListOnboardingPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOnboardingPoliciesRequest.Builder>(){

            @Override
            public ListOnboardingPoliciesRequest.Builder get() {
                return ListOnboardingPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOnboardingPoliciesResponse, String>(){

            @Override
            public String apply(ListOnboardingPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOnboardingPoliciesRequest.Builder>, ListOnboardingPoliciesRequest>(){

            @Override
            public ListOnboardingPoliciesRequest apply(RequestBuilderAndToken<ListOnboardingPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOnboardingPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOnboardingPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOnboardingPoliciesRequest, ListOnboardingPoliciesResponse>(){

            @Override
            public ListOnboardingPoliciesResponse apply(ListOnboardingPoliciesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listOnboardingPolicies(request);
            }
        }, (Function)new Function<ListOnboardingPoliciesResponse, List<OnboardingPolicySummary>>(){

            @Override
            public List<OnboardingPolicySummary> apply(ListOnboardingPoliciesResponse response) {
                return response.getOnboardingPolicyCollection().getItems();
            }
        });
    }

    public Iterable<ListOnboardingsResponse> listOnboardingsResponseIterator(final ListOnboardingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOnboardingsRequest.Builder>(){

            @Override
            public ListOnboardingsRequest.Builder get() {
                return ListOnboardingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOnboardingsResponse, String>(){

            @Override
            public String apply(ListOnboardingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOnboardingsRequest.Builder>, ListOnboardingsRequest>(){

            @Override
            public ListOnboardingsRequest apply(RequestBuilderAndToken<ListOnboardingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOnboardingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOnboardingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOnboardingsRequest, ListOnboardingsResponse>(){

            @Override
            public ListOnboardingsResponse apply(ListOnboardingsRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listOnboardings(request);
            }
        });
    }

    public Iterable<OnboardingSummary> listOnboardingsRecordIterator(final ListOnboardingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOnboardingsRequest.Builder>(){

            @Override
            public ListOnboardingsRequest.Builder get() {
                return ListOnboardingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOnboardingsResponse, String>(){

            @Override
            public String apply(ListOnboardingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOnboardingsRequest.Builder>, ListOnboardingsRequest>(){

            @Override
            public ListOnboardingsRequest apply(RequestBuilderAndToken<ListOnboardingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOnboardingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOnboardingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOnboardingsRequest, ListOnboardingsResponse>(){

            @Override
            public ListOnboardingsResponse apply(ListOnboardingsRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listOnboardings(request);
            }
        }, (Function)new Function<ListOnboardingsResponse, List<OnboardingSummary>>(){

            @Override
            public List<OnboardingSummary> apply(ListOnboardingsResponse response) {
                return response.getOnboardingCollection().getItems();
            }
        });
    }

    public Iterable<ListPlatformConfigurationsResponse> listPlatformConfigurationsResponseIterator(final ListPlatformConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPlatformConfigurationsRequest.Builder>(){

            @Override
            public ListPlatformConfigurationsRequest.Builder get() {
                return ListPlatformConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPlatformConfigurationsResponse, String>(){

            @Override
            public String apply(ListPlatformConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPlatformConfigurationsRequest.Builder>, ListPlatformConfigurationsRequest>(){

            @Override
            public ListPlatformConfigurationsRequest apply(RequestBuilderAndToken<ListPlatformConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPlatformConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPlatformConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPlatformConfigurationsRequest, ListPlatformConfigurationsResponse>(){

            @Override
            public ListPlatformConfigurationsResponse apply(ListPlatformConfigurationsRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listPlatformConfigurations(request);
            }
        });
    }

    public Iterable<PlatformConfigurationSummary> listPlatformConfigurationsRecordIterator(final ListPlatformConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPlatformConfigurationsRequest.Builder>(){

            @Override
            public ListPlatformConfigurationsRequest.Builder get() {
                return ListPlatformConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPlatformConfigurationsResponse, String>(){

            @Override
            public String apply(ListPlatformConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPlatformConfigurationsRequest.Builder>, ListPlatformConfigurationsRequest>(){

            @Override
            public ListPlatformConfigurationsRequest apply(RequestBuilderAndToken<ListPlatformConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPlatformConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPlatformConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPlatformConfigurationsRequest, ListPlatformConfigurationsResponse>(){

            @Override
            public ListPlatformConfigurationsResponse apply(ListPlatformConfigurationsRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listPlatformConfigurations(request);
            }
        }, (Function)new Function<ListPlatformConfigurationsResponse, List<PlatformConfigurationSummary>>(){

            @Override
            public List<PlatformConfigurationSummary> apply(ListPlatformConfigurationsResponse response) {
                return response.getPlatformConfigurationCollection().getItems();
            }
        });
    }

    public Iterable<ListPropertiesResponse> listPropertiesResponseIterator(final ListPropertiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPropertiesRequest.Builder>(){

            @Override
            public ListPropertiesRequest.Builder get() {
                return ListPropertiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPropertiesResponse, String>(){

            @Override
            public String apply(ListPropertiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPropertiesRequest.Builder>, ListPropertiesRequest>(){

            @Override
            public ListPropertiesRequest apply(RequestBuilderAndToken<ListPropertiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPropertiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPropertiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPropertiesRequest, ListPropertiesResponse>(){

            @Override
            public ListPropertiesResponse apply(ListPropertiesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listProperties(request);
            }
        });
    }

    public Iterable<PropertySummary> listPropertiesRecordIterator(final ListPropertiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPropertiesRequest.Builder>(){

            @Override
            public ListPropertiesRequest.Builder get() {
                return ListPropertiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPropertiesResponse, String>(){

            @Override
            public String apply(ListPropertiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPropertiesRequest.Builder>, ListPropertiesRequest>(){

            @Override
            public ListPropertiesRequest apply(RequestBuilderAndToken<ListPropertiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPropertiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPropertiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPropertiesRequest, ListPropertiesResponse>(){

            @Override
            public ListPropertiesResponse apply(ListPropertiesRequest request) {
                return FleetAppsManagementAdminPaginators.this.client.listProperties(request);
            }
        }, (Function)new Function<ListPropertiesResponse, List<PropertySummary>>(){

            @Override
            public List<PropertySummary> apply(ListPropertiesResponse response) {
                return response.getPropertyCollection().getItems();
            }
        });
    }
}

