/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementAdmin;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicy;
import com.oracle.bmc.fleetappsmanagement.model.CompliancePolicyRule;
import com.oracle.bmc.fleetappsmanagement.model.Onboarding;
import com.oracle.bmc.fleetappsmanagement.model.PlatformConfiguration;
import com.oracle.bmc.fleetappsmanagement.model.Property;
import com.oracle.bmc.fleetappsmanagement.requests.GetCompliancePolicyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetCompliancePolicyRuleRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetOnboardingRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetPlatformConfigurationRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetPropertyRequest;
import com.oracle.bmc.fleetappsmanagement.responses.GetCompliancePolicyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetCompliancePolicyRuleResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetOnboardingResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetPlatformConfigurationResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetPropertyResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FleetAppsManagementAdminWaiters {
    private final ExecutorService executorService;
    private final FleetAppsManagementAdmin client;

    public FleetAppsManagementAdminWaiters(ExecutorService executorService, FleetAppsManagementAdmin client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetCompliancePolicyRequest, GetCompliancePolicyResponse> forCompliancePolicy(GetCompliancePolicyRequest request, CompliancePolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCompliancePolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCompliancePolicyRequest, GetCompliancePolicyResponse> forCompliancePolicy(GetCompliancePolicyRequest request, CompliancePolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCompliancePolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCompliancePolicyRequest, GetCompliancePolicyResponse> forCompliancePolicy(GetCompliancePolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CompliancePolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCompliancePolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCompliancePolicyRequest, GetCompliancePolicyResponse> forCompliancePolicy(BmcGenericWaiter waiter, GetCompliancePolicyRequest request, CompliancePolicy.LifecycleState ... targetStates) {
        final HashSet<CompliancePolicy.LifecycleState> targetStatesSet = new HashSet<CompliancePolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCompliancePolicyRequest, GetCompliancePolicyResponse>(){

            @Override
            public GetCompliancePolicyResponse apply(GetCompliancePolicyRequest request) {
                return FleetAppsManagementAdminWaiters.this.client.getCompliancePolicy(request);
            }
        }, (Predicate)new Predicate<GetCompliancePolicyResponse>(){

            @Override
            public boolean test(GetCompliancePolicyResponse response) {
                return targetStatesSet.contains((Object)response.getCompliancePolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CompliancePolicy.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCompliancePolicyRuleRequest, GetCompliancePolicyRuleResponse> forCompliancePolicyRule(GetCompliancePolicyRuleRequest request, CompliancePolicyRule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCompliancePolicyRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCompliancePolicyRuleRequest, GetCompliancePolicyRuleResponse> forCompliancePolicyRule(GetCompliancePolicyRuleRequest request, CompliancePolicyRule.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCompliancePolicyRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCompliancePolicyRuleRequest, GetCompliancePolicyRuleResponse> forCompliancePolicyRule(GetCompliancePolicyRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CompliancePolicyRule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCompliancePolicyRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCompliancePolicyRuleRequest, GetCompliancePolicyRuleResponse> forCompliancePolicyRule(BmcGenericWaiter waiter, GetCompliancePolicyRuleRequest request, CompliancePolicyRule.LifecycleState ... targetStates) {
        final HashSet<CompliancePolicyRule.LifecycleState> targetStatesSet = new HashSet<CompliancePolicyRule.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCompliancePolicyRuleRequest, GetCompliancePolicyRuleResponse>(){

            @Override
            public GetCompliancePolicyRuleResponse apply(GetCompliancePolicyRuleRequest request) {
                return FleetAppsManagementAdminWaiters.this.client.getCompliancePolicyRule(request);
            }
        }, (Predicate)new Predicate<GetCompliancePolicyRuleResponse>(){

            @Override
            public boolean test(GetCompliancePolicyRuleResponse response) {
                return targetStatesSet.contains((Object)response.getCompliancePolicyRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CompliancePolicyRule.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOnboardingRequest, GetOnboardingResponse> forOnboarding(GetOnboardingRequest request, Onboarding.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOnboarding(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOnboardingRequest, GetOnboardingResponse> forOnboarding(GetOnboardingRequest request, Onboarding.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOnboarding(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOnboardingRequest, GetOnboardingResponse> forOnboarding(GetOnboardingRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Onboarding.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOnboarding(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOnboardingRequest, GetOnboardingResponse> forOnboarding(BmcGenericWaiter waiter, GetOnboardingRequest request, Onboarding.LifecycleState ... targetStates) {
        final HashSet<Onboarding.LifecycleState> targetStatesSet = new HashSet<Onboarding.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOnboardingRequest, GetOnboardingResponse>(){

            @Override
            public GetOnboardingResponse apply(GetOnboardingRequest request) {
                return FleetAppsManagementAdminWaiters.this.client.getOnboarding(request);
            }
        }, (Predicate)new Predicate<GetOnboardingResponse>(){

            @Override
            public boolean test(GetOnboardingResponse response) {
                return targetStatesSet.contains((Object)response.getOnboarding().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Onboarding.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPlatformConfigurationRequest, GetPlatformConfigurationResponse> forPlatformConfiguration(GetPlatformConfigurationRequest request, PlatformConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPlatformConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPlatformConfigurationRequest, GetPlatformConfigurationResponse> forPlatformConfiguration(GetPlatformConfigurationRequest request, PlatformConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPlatformConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPlatformConfigurationRequest, GetPlatformConfigurationResponse> forPlatformConfiguration(GetPlatformConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PlatformConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPlatformConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPlatformConfigurationRequest, GetPlatformConfigurationResponse> forPlatformConfiguration(BmcGenericWaiter waiter, GetPlatformConfigurationRequest request, PlatformConfiguration.LifecycleState ... targetStates) {
        final HashSet<PlatformConfiguration.LifecycleState> targetStatesSet = new HashSet<PlatformConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPlatformConfigurationRequest, GetPlatformConfigurationResponse>(){

            @Override
            public GetPlatformConfigurationResponse apply(GetPlatformConfigurationRequest request) {
                return FleetAppsManagementAdminWaiters.this.client.getPlatformConfiguration(request);
            }
        }, (Predicate)new Predicate<GetPlatformConfigurationResponse>(){

            @Override
            public boolean test(GetPlatformConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getPlatformConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PlatformConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPropertyRequest, GetPropertyResponse> forProperty(GetPropertyRequest request, Property.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProperty(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPropertyRequest, GetPropertyResponse> forProperty(GetPropertyRequest request, Property.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProperty(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPropertyRequest, GetPropertyResponse> forProperty(GetPropertyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Property.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forProperty(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPropertyRequest, GetPropertyResponse> forProperty(BmcGenericWaiter waiter, GetPropertyRequest request, Property.LifecycleState ... targetStates) {
        final HashSet<Property.LifecycleState> targetStatesSet = new HashSet<Property.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPropertyRequest, GetPropertyResponse>(){

            @Override
            public GetPropertyResponse apply(GetPropertyRequest request) {
                return FleetAppsManagementAdminWaiters.this.client.getProperty(request);
            }
        }, (Predicate)new Predicate<GetPropertyResponse>(){

            @Override
            public boolean test(GetPropertyResponse response) {
                return targetStatesSet.contains((Object)response.getProperty().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Property.LifecycleState.Deleted)), (Object)request);
    }
}

