/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementAsync;
import com.oracle.bmc.fleetappsmanagement.model.AnnouncementCollection;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceReport;
import com.oracle.bmc.fleetappsmanagement.model.Fleet;
import com.oracle.bmc.fleetappsmanagement.model.FleetCollection;
import com.oracle.bmc.fleetappsmanagement.model.FleetCredential;
import com.oracle.bmc.fleetappsmanagement.model.FleetCredentialCollection;
import com.oracle.bmc.fleetappsmanagement.model.FleetProductCollection;
import com.oracle.bmc.fleetappsmanagement.model.FleetProperty;
import com.oracle.bmc.fleetappsmanagement.model.FleetPropertyCollection;
import com.oracle.bmc.fleetappsmanagement.model.FleetResource;
import com.oracle.bmc.fleetappsmanagement.model.FleetResourceCollection;
import com.oracle.bmc.fleetappsmanagement.model.FleetTargetCollection;
import com.oracle.bmc.fleetappsmanagement.model.InventoryResourceCollection;
import com.oracle.bmc.fleetappsmanagement.model.ResourceTagCheckDetails;
import com.oracle.bmc.fleetappsmanagement.model.WorkRequest;
import com.oracle.bmc.fleetappsmanagement.model.WorkRequestErrorCollection;
import com.oracle.bmc.fleetappsmanagement.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.fleetappsmanagement.model.WorkRequestSummaryCollection;
import com.oracle.bmc.fleetappsmanagement.requests.CheckResourceTaggingRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ConfirmTargetsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreateFleetCredentialRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreateFleetPropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreateFleetRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreateFleetResourceRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteFleetCredentialRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteFleetPropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteFleetRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteFleetResourceRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GenerateComplianceReportRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetComplianceReportRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetCredentialRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetPropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetResourceRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListAnnouncementsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListFleetCredentialsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListFleetProductsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListFleetPropertiesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListFleetResourcesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListFleetTargetsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListFleetsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListInventoryResourcesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListTargetsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.RequestResourceValidationRequest;
import com.oracle.bmc.fleetappsmanagement.requests.RequestTargetDiscoveryRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateFleetCredentialRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateFleetPropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateFleetRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateFleetResourceRequest;
import com.oracle.bmc.fleetappsmanagement.responses.CheckResourceTaggingResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ConfirmTargetsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreateFleetCredentialResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreateFleetPropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreateFleetResourceResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreateFleetResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteFleetCredentialResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteFleetPropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteFleetResourceResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteFleetResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GenerateComplianceReportResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetComplianceReportResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetCredentialResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetPropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetResourceResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListAnnouncementsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListFleetCredentialsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListFleetProductsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListFleetPropertiesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListFleetResourcesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListFleetTargetsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListFleetsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListInventoryResourcesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListTargetsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.RequestResourceValidationResponse;
import com.oracle.bmc.fleetappsmanagement.responses.RequestTargetDiscoveryResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateFleetCredentialResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateFleetPropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateFleetResourceResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateFleetResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetAppsManagementAsyncClient
extends BaseAsyncClient
implements FleetAppsManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETAPPSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://fams.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetAppsManagementAsyncClient.class);

    FleetAppsManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CheckResourceTaggingResponse> checkResourceTagging(CheckResourceTaggingRequest request, AsyncHandler<CheckResourceTaggingRequest, CheckResourceTaggingResponse> handler) {
        Objects.requireNonNull(request.getCheckResourceTaggingDetails(), "checkResourceTaggingDetails is required");
        return this.clientCall(request, CheckResourceTaggingResponse::builder).logger(LOG, "checkResourceTagging").serviceDetails("FleetAppsManagement", "CheckResourceTagging", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/CheckResourceTagging").method(Method.POST).requestBuilder(CheckResourceTaggingRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam("actions").appendPathParam("checkResourceTagging").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResourceTagCheckDetails.class, CheckResourceTaggingResponse.Builder::resourceTagCheckDetails).handleResponseHeaderString("etag", CheckResourceTaggingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CheckResourceTaggingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ConfirmTargetsResponse> confirmTargets(ConfirmTargetsRequest request, AsyncHandler<ConfirmTargetsRequest, ConfirmTargetsResponse> handler) {
        Objects.requireNonNull(request.getConfirmTargetsDetails(), "confirmTargetsDetails is required");
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ConfirmTargetsResponse::builder).logger(LOG, "confirmTargets").serviceDetails("FleetAppsManagement", "ConfirmTargets", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/ConfirmTargets").method(Method.POST).requestBuilder(ConfirmTargetsRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("confirmTargets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ConfirmTargetsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ConfirmTargetsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFleetResponse> createFleet(CreateFleetRequest request, AsyncHandler<CreateFleetRequest, CreateFleetResponse> handler) {
        Objects.requireNonNull(request.getCreateFleetDetails(), "createFleetDetails is required");
        return this.clientCall(request, CreateFleetResponse::builder).logger(LOG, "createFleet").serviceDetails("FleetAppsManagement", "CreateFleet", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/CreateFleet").method(Method.POST).requestBuilder(CreateFleetRequest::builder).basePath("/20230831").appendPathParam("fleets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Fleet.class, CreateFleetResponse.Builder::fleet).handleResponseHeaderString("location", CreateFleetResponse.Builder::location).handleResponseHeaderString("content-location", CreateFleetResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateFleetResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFleetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFleetCredentialResponse> createFleetCredential(CreateFleetCredentialRequest request, AsyncHandler<CreateFleetCredentialRequest, CreateFleetCredentialResponse> handler) {
        Objects.requireNonNull(request.getCreateFleetCredentialDetails(), "createFleetCredentialDetails is required");
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateFleetCredentialResponse::builder).logger(LOG, "createFleetCredential").serviceDetails("FleetAppsManagement", "CreateFleetCredential", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetCredential/CreateFleetCredential").method(Method.POST).requestBuilder(CreateFleetCredentialRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetCredentials").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FleetCredential.class, CreateFleetCredentialResponse.Builder::fleetCredential).handleResponseHeaderString("location", CreateFleetCredentialResponse.Builder::location).handleResponseHeaderString("content-location", CreateFleetCredentialResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateFleetCredentialResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateFleetCredentialResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFleetCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFleetPropertyResponse> createFleetProperty(CreateFleetPropertyRequest request, AsyncHandler<CreateFleetPropertyRequest, CreateFleetPropertyResponse> handler) {
        Objects.requireNonNull(request.getCreateFleetPropertyDetails(), "createFleetPropertyDetails is required");
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateFleetPropertyResponse::builder).logger(LOG, "createFleetProperty").serviceDetails("FleetAppsManagement", "CreateFleetProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetProperty/CreateFleetProperty").method(Method.POST).requestBuilder(CreateFleetPropertyRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetProperties").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FleetProperty.class, CreateFleetPropertyResponse.Builder::fleetProperty).handleResponseHeaderString("etag", CreateFleetPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFleetPropertyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFleetResourceResponse> createFleetResource(CreateFleetResourceRequest request, AsyncHandler<CreateFleetResourceRequest, CreateFleetResourceResponse> handler) {
        Objects.requireNonNull(request.getCreateFleetResourceDetails(), "createFleetResourceDetails is required");
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateFleetResourceResponse::builder).logger(LOG, "createFleetResource").serviceDetails("FleetAppsManagement", "CreateFleetResource", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetResource/CreateFleetResource").method(Method.POST).requestBuilder(CreateFleetResourceRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetResources").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FleetResource.class, CreateFleetResourceResponse.Builder::fleetResource).handleResponseHeaderString("location", CreateFleetResourceResponse.Builder::location).handleResponseHeaderString("content-location", CreateFleetResourceResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateFleetResourceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateFleetResourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFleetResourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFleetResponse> deleteFleet(DeleteFleetRequest request, AsyncHandler<DeleteFleetRequest, DeleteFleetResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFleetResponse::builder).logger(LOG, "deleteFleet").serviceDetails("FleetAppsManagement", "DeleteFleet", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/DeleteFleet").method(Method.DELETE).requestBuilder(DeleteFleetRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFleetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFleetCredentialResponse> deleteFleetCredential(DeleteFleetCredentialRequest request, AsyncHandler<DeleteFleetCredentialRequest, DeleteFleetCredentialResponse> handler) {
        Validate.notBlank((String)request.getFleetCredentialId(), (String)"fleetCredentialId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFleetCredentialResponse::builder).logger(LOG, "deleteFleetCredential").serviceDetails("FleetAppsManagement", "DeleteFleetCredential", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetCredential/DeleteFleetCredential").method(Method.DELETE).requestBuilder(DeleteFleetCredentialRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetCredentials").appendPathParam(request.getFleetCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFleetCredentialResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFleetCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFleetPropertyResponse> deleteFleetProperty(DeleteFleetPropertyRequest request, AsyncHandler<DeleteFleetPropertyRequest, DeleteFleetPropertyResponse> handler) {
        Validate.notBlank((String)request.getFleetPropertyId(), (String)"fleetPropertyId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFleetPropertyResponse::builder).logger(LOG, "deleteFleetProperty").serviceDetails("FleetAppsManagement", "DeleteFleetProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetProperty/DeleteFleetProperty").method(Method.DELETE).requestBuilder(DeleteFleetPropertyRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetProperties").appendPathParam(request.getFleetPropertyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFleetPropertyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFleetResourceResponse> deleteFleetResource(DeleteFleetResourceRequest request, AsyncHandler<DeleteFleetResourceRequest, DeleteFleetResourceResponse> handler) {
        Validate.notBlank((String)request.getFleetResourceId(), (String)"fleetResourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFleetResourceResponse::builder).logger(LOG, "deleteFleetResource").serviceDetails("FleetAppsManagement", "DeleteFleetResource", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetResource/DeleteFleetResource").method(Method.DELETE).requestBuilder(DeleteFleetResourceRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetResources").appendPathParam(request.getFleetResourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFleetResourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFleetResourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateComplianceReportResponse> generateComplianceReport(GenerateComplianceReportRequest request, AsyncHandler<GenerateComplianceReportRequest, GenerateComplianceReportResponse> handler) {
        Objects.requireNonNull(request.getGenerateComplianceReportDetails(), "generateComplianceReportDetails is required");
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateComplianceReportResponse::builder).logger(LOG, "generateComplianceReport").serviceDetails("FleetAppsManagement", "GenerateComplianceReport", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/GenerateComplianceReport").method(Method.POST).requestBuilder(GenerateComplianceReportRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("generateComplianceReport").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", GenerateComplianceReportResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GenerateComplianceReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetComplianceReportResponse> getComplianceReport(GetComplianceReportRequest request, AsyncHandler<GetComplianceReportRequest, GetComplianceReportResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getComplianceReportId(), (String)"complianceReportId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetComplianceReportResponse::builder).logger(LOG, "getComplianceReport").serviceDetails("FleetAppsManagement", "GetComplianceReport", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ComplianceReport/GetComplianceReport").method(Method.GET).requestBuilder(GetComplianceReportRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("complianceReports").appendPathParam(request.getComplianceReportId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComplianceReport.class, GetComplianceReportResponse.Builder::complianceReport).handleResponseHeaderString("etag", GetComplianceReportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComplianceReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFleetResponse> getFleet(GetFleetRequest request, AsyncHandler<GetFleetRequest, GetFleetResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFleetResponse::builder).logger(LOG, "getFleet").serviceDetails("FleetAppsManagement", "GetFleet", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/GetFleet").method(Method.GET).requestBuilder(GetFleetRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Fleet.class, GetFleetResponse.Builder::fleet).handleResponseHeaderString("etag", GetFleetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFleetCredentialResponse> getFleetCredential(GetFleetCredentialRequest request, AsyncHandler<GetFleetCredentialRequest, GetFleetCredentialResponse> handler) {
        Validate.notBlank((String)request.getFleetCredentialId(), (String)"fleetCredentialId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFleetCredentialResponse::builder).logger(LOG, "getFleetCredential").serviceDetails("FleetAppsManagement", "GetFleetCredential", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetCredential/GetFleetCredential").method(Method.GET).requestBuilder(GetFleetCredentialRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetCredentials").appendPathParam(request.getFleetCredentialId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetCredential.class, GetFleetCredentialResponse.Builder::fleetCredential).handleResponseHeaderString("etag", GetFleetCredentialResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFleetPropertyResponse> getFleetProperty(GetFleetPropertyRequest request, AsyncHandler<GetFleetPropertyRequest, GetFleetPropertyResponse> handler) {
        Validate.notBlank((String)request.getFleetPropertyId(), (String)"fleetPropertyId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFleetPropertyResponse::builder).logger(LOG, "getFleetProperty").serviceDetails("FleetAppsManagement", "GetFleetProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetProperty/GetFleetProperty").method(Method.GET).requestBuilder(GetFleetPropertyRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetProperties").appendPathParam(request.getFleetPropertyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetProperty.class, GetFleetPropertyResponse.Builder::fleetProperty).handleResponseHeaderString("etag", GetFleetPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetPropertyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFleetResourceResponse> getFleetResource(GetFleetResourceRequest request, AsyncHandler<GetFleetResourceRequest, GetFleetResourceResponse> handler) {
        Validate.notBlank((String)request.getFleetResourceId(), (String)"fleetResourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFleetResourceResponse::builder).logger(LOG, "getFleetResource").serviceDetails("FleetAppsManagement", "GetFleetResource", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetResource/GetFleetResource").method(Method.GET).requestBuilder(GetFleetResourceRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetResources").appendPathParam(request.getFleetResourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetResource.class, GetFleetResourceResponse.Builder::fleetResource).handleResponseHeaderString("etag", GetFleetResourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetResourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("FleetAppsManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20230831").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAnnouncementsResponse> listAnnouncements(ListAnnouncementsRequest request, AsyncHandler<ListAnnouncementsRequest, ListAnnouncementsResponse> handler) {
        return this.clientCall(request, ListAnnouncementsResponse::builder).logger(LOG, "listAnnouncements").serviceDetails("FleetAppsManagement", "ListAnnouncements", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/AnnouncementCollection/ListAnnouncements").method(Method.GET).requestBuilder(ListAnnouncementsRequest::builder).basePath("/20230831").appendPathParam("announcements").appendQueryParam("summaryContains", (Object)request.getSummaryContains()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnouncementCollection.class, ListAnnouncementsResponse.Builder::announcementCollection).handleResponseHeaderString("opc-request-id", ListAnnouncementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAnnouncementsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFleetCredentialsResponse> listFleetCredentials(ListFleetCredentialsRequest request, AsyncHandler<ListFleetCredentialsRequest, ListFleetCredentialsResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFleetCredentialsResponse::builder).logger(LOG, "listFleetCredentials").serviceDetails("FleetAppsManagement", "ListFleetCredentials", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetCredentialCollection/ListFleetCredentials").method(Method.GET).requestBuilder(ListFleetCredentialsRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetCredentials").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("target", (Object)request.getTarget()).appendEnumQueryParam("credentialLevel", (BmcEnum)request.getCredentialLevel()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetCredentialCollection.class, ListFleetCredentialsResponse.Builder::fleetCredentialCollection).handleResponseHeaderString("opc-request-id", ListFleetCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetCredentialsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFleetProductsResponse> listFleetProducts(ListFleetProductsRequest request, AsyncHandler<ListFleetProductsRequest, ListFleetProductsResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFleetProductsResponse::builder).logger(LOG, "listFleetProducts").serviceDetails("FleetAppsManagement", "ListFleetProducts", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetProductCollection/ListFleetProducts").method(Method.GET).requestBuilder(ListFleetProductsRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetProducts").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("resourceDisplayName", (Object)request.getResourceDisplayName()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetProductCollection.class, ListFleetProductsResponse.Builder::fleetProductCollection).handleResponseHeaderString("opc-request-id", ListFleetProductsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetProductsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFleetPropertiesResponse> listFleetProperties(ListFleetPropertiesRequest request, AsyncHandler<ListFleetPropertiesRequest, ListFleetPropertiesResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFleetPropertiesResponse::builder).logger(LOG, "listFleetProperties").serviceDetails("FleetAppsManagement", "ListFleetProperties", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetPropertyCollection/ListFleetProperties").method(Method.GET).requestBuilder(ListFleetPropertiesRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetProperties").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetPropertyCollection.class, ListFleetPropertiesResponse.Builder::fleetPropertyCollection).handleResponseHeaderString("opc-request-id", ListFleetPropertiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetPropertiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFleetResourcesResponse> listFleetResources(ListFleetResourcesRequest request, AsyncHandler<ListFleetResourcesRequest, ListFleetResourcesResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFleetResourcesResponse::builder).logger(LOG, "listFleetResources").serviceDetails("FleetAppsManagement", "ListFleetResources", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetResourceCollection/ListFleetResources").method(Method.GET).requestBuilder(ListFleetResourcesRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetResources").appendQueryParam("tenancyId", (Object)request.getTenancyId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("fleetResourceType", (Object)request.getFleetResourceType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetResourceCollection.class, ListFleetResourcesResponse.Builder::fleetResourceCollection).handleResponseHeaderString("opc-request-id", ListFleetResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetResourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFleetTargetsResponse> listFleetTargets(ListFleetTargetsRequest request, AsyncHandler<ListFleetTargetsRequest, ListFleetTargetsResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFleetTargetsResponse::builder).logger(LOG, "listFleetTargets").serviceDetails("FleetAppsManagement", "ListFleetTargets", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetTargetCollection/ListFleetTargets").method(Method.GET).requestBuilder(ListFleetTargetsRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetTargets").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("product", (Object)request.getProduct()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("resourceDisplayName", (Object)request.getResourceDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetTargetCollection.class, ListFleetTargetsResponse.Builder::fleetTargetCollection).handleResponseHeaderString("opc-request-id", ListFleetTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetTargetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFleetsResponse> listFleets(ListFleetsRequest request, AsyncHandler<ListFleetsRequest, ListFleetsResponse> handler) {
        return this.clientCall(request, ListFleetsResponse::builder).logger(LOG, "listFleets").serviceDetails("FleetAppsManagement", "ListFleets", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetCollection/ListFleets").method(Method.GET).requestBuilder(ListFleetsRequest::builder).basePath("/20230831").appendPathParam("fleets").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("fleetType", (BmcEnum)request.getFleetType()).appendQueryParam("applicationType", (Object)request.getApplicationType()).appendQueryParam("product", (Object)request.getProduct()).appendQueryParam("environmentType", (Object)request.getEnvironmentType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetCollection.class, ListFleetsResponse.Builder::fleetCollection).handleResponseHeaderString("opc-request-id", ListFleetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListFleetsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListInventoryResourcesResponse> listInventoryResources(ListInventoryResourcesRequest request, AsyncHandler<ListInventoryResourcesRequest, ListInventoryResourcesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getResourceCompartmentId(), "resourceCompartmentId is required");
        return this.clientCall(request, ListInventoryResourcesResponse::builder).logger(LOG, "listInventoryResources").serviceDetails("FleetAppsManagement", "ListInventoryResources", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/InventoryResourceCollection/ListInventoryResources").method(Method.GET).requestBuilder(ListInventoryResourcesRequest::builder).basePath("/20230831").appendPathParam("inventoryResources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("resourceRegion", (Object)request.getResourceRegion()).appendQueryParam("resourceCompartmentId", (Object)request.getResourceCompartmentId()).appendListQueryParam("definedTagEquals", request.getDefinedTagEquals(), CollectionFormatType.Multi).appendListQueryParam("freeformTagEquals", request.getFreeformTagEquals(), CollectionFormatType.Multi).appendListQueryParam("inventoryProperties", request.getInventoryProperties(), CollectionFormatType.Multi).appendQueryParam("matchingCriteria", (Object)request.getMatchingCriteria()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InventoryResourceCollection.class, ListInventoryResourcesResponse.Builder::inventoryResourceCollection).handleResponseHeaderString("opc-request-id", ListInventoryResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInventoryResourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTargetsResponse> listTargets(ListTargetsRequest request, AsyncHandler<ListTargetsRequest, ListTargetsResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTargetsResponse::builder).logger(LOG, "listTargets").serviceDetails("FleetAppsManagement", "ListTargets", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetTargetCollection/ListTargets").method(Method.GET).requestBuilder(ListTargetsRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("targets").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetTargetCollection.class, ListTargetsResponse.Builder::fleetTargetCollection).handleResponseHeaderString("opc-request-id", ListTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTargetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("FleetAppsManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20230831").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("FleetAppsManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20230831").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("FleetAppsManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20230831").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RequestResourceValidationResponse> requestResourceValidation(RequestResourceValidationRequest request, AsyncHandler<RequestResourceValidationRequest, RequestResourceValidationResponse> handler) {
        Objects.requireNonNull(request.getRequestResourceValidationDetails(), "requestResourceValidationDetails is required");
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RequestResourceValidationResponse::builder).logger(LOG, "requestResourceValidation").serviceDetails("FleetAppsManagement", "RequestResourceValidation", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/RequestResourceValidation").method(Method.POST).requestBuilder(RequestResourceValidationRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestResourceValidation").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RequestResourceValidationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestResourceValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RequestTargetDiscoveryResponse> requestTargetDiscovery(RequestTargetDiscoveryRequest request, AsyncHandler<RequestTargetDiscoveryRequest, RequestTargetDiscoveryResponse> handler) {
        Objects.requireNonNull(request.getRequestTargetDiscoveryDetails(), "requestTargetDiscoveryDetails is required");
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RequestTargetDiscoveryResponse::builder).logger(LOG, "requestTargetDiscovery").serviceDetails("FleetAppsManagement", "RequestTargetDiscovery", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/RequestTargetDiscovery").method(Method.POST).requestBuilder(RequestTargetDiscoveryRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestTargetDiscovery").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RequestTargetDiscoveryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestTargetDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFleetResponse> updateFleet(UpdateFleetRequest request, AsyncHandler<UpdateFleetRequest, UpdateFleetResponse> handler) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetDetails(), "updateFleetDetails is required");
        return this.clientCall(request, UpdateFleetResponse::builder).logger(LOG, "updateFleet").serviceDetails("FleetAppsManagement", "UpdateFleet", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Fleet/UpdateFleet").method(Method.PUT).requestBuilder(UpdateFleetRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Fleet.class, UpdateFleetResponse.Builder::fleet).handleResponseHeaderString("etag", UpdateFleetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFleetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFleetCredentialResponse> updateFleetCredential(UpdateFleetCredentialRequest request, AsyncHandler<UpdateFleetCredentialRequest, UpdateFleetCredentialResponse> handler) {
        Validate.notBlank((String)request.getFleetCredentialId(), (String)"fleetCredentialId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetCredentialDetails(), "updateFleetCredentialDetails is required");
        return this.clientCall(request, UpdateFleetCredentialResponse::builder).logger(LOG, "updateFleetCredential").serviceDetails("FleetAppsManagement", "UpdateFleetCredential", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetCredential/UpdateFleetCredential").method(Method.PUT).requestBuilder(UpdateFleetCredentialRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetCredentials").appendPathParam(request.getFleetCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFleetCredentialResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFleetCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFleetPropertyResponse> updateFleetProperty(UpdateFleetPropertyRequest request, AsyncHandler<UpdateFleetPropertyRequest, UpdateFleetPropertyResponse> handler) {
        Validate.notBlank((String)request.getFleetPropertyId(), (String)"fleetPropertyId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetPropertyDetails(), "updateFleetPropertyDetails is required");
        return this.clientCall(request, UpdateFleetPropertyResponse::builder).logger(LOG, "updateFleetProperty").serviceDetails("FleetAppsManagement", "UpdateFleetProperty", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetProperty/UpdateFleetProperty").method(Method.PUT).requestBuilder(UpdateFleetPropertyRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetProperties").appendPathParam(request.getFleetPropertyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FleetProperty.class, UpdateFleetPropertyResponse.Builder::fleetProperty).handleResponseHeaderString("etag", UpdateFleetPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFleetPropertyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFleetResourceResponse> updateFleetResource(UpdateFleetResourceRequest request, AsyncHandler<UpdateFleetResourceRequest, UpdateFleetResourceResponse> handler) {
        Validate.notBlank((String)request.getFleetResourceId(), (String)"fleetResourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetResourceDetails(), "updateFleetResourceDetails is required");
        return this.clientCall(request, UpdateFleetResourceResponse::builder).logger(LOG, "updateFleetResource").serviceDetails("FleetAppsManagement", "UpdateFleetResource", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/FleetResource/UpdateFleetResource").method(Method.PUT).requestBuilder(UpdateFleetResourceRequest::builder).basePath("/20230831").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("fleetResources").appendPathParam(request.getFleetResourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFleetResourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFleetResourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public FleetAppsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetAppsManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetAppsManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetAppsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetAppsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetAppsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetAppsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetAppsManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "fleetappsmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetappsmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public FleetAppsManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetAppsManagementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

